# Python 封装

使用类的方法获取相关信息，可以将内部的实现细节封装起来

```python
# -*- coding: UTF-8 -*-
class Student:
    def __init__(self, no, name, age):
        # TODO(初始化)

    def no(self):
        # TODO(返回编号)

    def name(self):
        # TODO(返回名字)

    def age(self):
        # TODO(返回年龄)

if __name__ == '__main__':
    s = Student(0, f'somebody', 20)
    print(f'* {s.no()}')
    print(f'* {s.name()}')
    print(f'* {s.age()}')
```

以下对Student的实现，**不正确**的代码是？

## template

```python
class Student:
    def __init__(self, no, name, age):
        self._no = no
        self._name = name
        self._age = age

    def no(self):
        return self._no

    def name(self):
        return self._name

    def age(self):
        return self._age

if __name__ == '__main__':
    s = Student(0, f'somebody', 20)
    print(f'* {s.no()}')
    print(f'* {s.name()}')
    print(f'* {s.age()}')
```

## 答案

```python
class Student:
    def __init__(self, no, name, age):
        self.no = no
        self.name = name
        self.age = age

    def no(self):
        return self.no

    def name(self):
        return self.name

    def age(self):
        return self.age
```

## 选项

### A

```python
class Student:
    def __init__(self, no, name, age):
        self._no = no
        self._name = name
        self._age = age

    def no(self):
        return self._no

    def name(self):
        return self._name

    def age(self):
        return self._age
```

### B

```python
class Student:
    def __init__(self, no, name, age):
        self.info = {
            'no': no,
            'name': name,
            'age': age
        }

    def no(self):
        return self.info['no']

    def name(self):
        return self.info['name']

    def age(self):
        return self.info['age']
```

### C

```python
class Student:
    def __init__(self, no, name, age):
        self.info =[no, name, age]

    def no(self):
        return self.info[0]

    def name(self):
        return self.info[1]

    def age(self):
        return self.info[2]
```
