# Python 生成器推导式

Python 独步天下的推导式表达式，使用元表推式过滤长度小于等于4的书籍

```python
def test():
	books = ('程序员修炼之道', '构建之法', '代码大全', 'TCP/IP协议详解')

	# 此处请为reading进行正确的赋值

	print("太长的书就不看了，只读短的：")
	for book in reading:
		print(" ->《{}》".format(book))

	print("可是发现书的名字短，内容也可能很长啊！")


if __name__ == '__main__':
	test()
```

请选出下列能**正确**实现这一功能的选项。

## 答案

```python
reading (book for book in books if len(book) <= 4)
```



## 选项

### A

```python
reading = (books[i] for book in books: if len(book) < 4)
```

### B

```python
reading = (book for book in books if len(book) < 4)
```

### C

```python
reading = (book for book in books: if len(book) <= 4)
```







