# Python WxPython 例子

继承上一题的 BasicFrame 增加功能

1. 创建面板
2. 添加 “Hello World” 文本
3. 添加一个 “Close” 按钮
4. 绑定关闭事件

```python
# -*- coding: UTF-8 -*-
import wx
from create_window import BasicFrame

class PanelFrame(BasicFrame):
    def __init__(self, title, pos, size):
        super().__init__(title, pos, size)
        self.init_panel()

    def init_panel(self):
        # TODO(You): 请在此实现代码


if __name__ == '__main__':
    app = wx.App(redirect=True)
    top = PanelFrame(
        title="Hello World",
        pos=(150, 150),
        size=(350, 200)
    )
    top.Show()
    app.MainLoop()
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import wx
from create_window import BasicFrame


class PanelFrame(BasicFrame):
    def __init__(self, title, pos, size):
        super().__init__(title, pos, size)
        self.init_panel()

    def init_panel(self):
        panel = wx.Panel(self)
        box = wx.BoxSizer(wx.VERTICAL)

        m_text = wx.StaticText(panel, -1, "Hello World!")
        m_text.SetFont(wx.Font(14, wx.SWISS, wx.NORMAL, wx.BOLD))
        m_text.SetSize(m_text.GetBestSize())
        box.Add(m_text, 0, wx.ALL, 10)

        m_close = wx.Button(panel, wx.ID_CLOSE, "Close")
        m_close.Bind(wx.EVT_BUTTON, self.OnClose)
        box.Add(m_close, 0, wx.ALL, 10)

        panel.SetSizer(box)
        panel.Layout()


if __name__ == '__main__':
    app = wx.App(redirect=True)
    top = PanelFrame(
        title="Hello World",
        pos=(150, 150),
        size=(350, 200)
    )
    top.Show()
    app.MainLoop()
```

## 答案

```python
class PanelFrame(BasicFrame):
    ...
    def init_panel(self):
        panel = wx.Panel(self)
        box = wx.BoxSizer(wx.VERTICAL)

        m_text = wx.StaticText(panel, -1, "Hello World!")
        m_text.SetFont(wx.Font(14, wx.SWISS, wx.NORMAL, wx.BOLD))
        m_text.SetSize(m_text.GetBestSize())
        box.Add(m_text, 0, wx.ALL, 10)

        m_close = wx.Button(panel, wx.ID_CLOSE, "Close")
        m_close.Bind(wx.EVT_BUTTON, self.OnClose)
        box.Add(m_close, 0, wx.ALL, 10)

        panel.SetSizer(box)
        panel.Layout()
```

## 选项

### A

```python
class PanelFrame(BasicFrame):
    ...
    def init_panel(self):
        panel = wx.Panel(self)
        box = wx.BoxSizer(wx.VERTICAL)

        m_text = wx.StaticText(panel, -1, "Hello World!")
        m_text.SetFont(wx.Font(14, wx.SWISS, wx.NORMAL, wx.BOLD))
        m_text.SetSize(m_text.GetBestSize())
        box.Add(m_text, 0, wx.ALL, 10)

        m_close = wx.Button(panel, wx.ID_CLOSE, "Close")
        m_close.Bind(wx.EVT_BUTTON, self.OnClose)
        box.Add(m_close, 0, wx.ALL, 10)
```

### B

```python
class PanelFrame(BasicFrame):
    ...
    def init_panel(self):
        panel = wx.Panel(self)
        box = wx.BoxSizer(wx.VERTICAL)

        m_text = wx.StaticText(panel, -1, "Hello World!")
        m_text.SetFont(wx.Font(14, wx.SWISS, wx.NORMAL, wx.BOLD))
        m_text.SetSize(m_text.GetBestSize())

        m_close = wx.Button(panel, wx.ID_CLOSE, "Close")
        m_close.Bind(wx.EVT_BUTTON, self.OnClose)

        panel.SetSizer(box)
        panel.Layout()
```

### C

```python
class PanelFrame(BasicFrame):
    ...
    def init_panel(self):
        panel = wx.Panel(self)
        box = wx.BoxSizer(wx.VERTICAL)

        m_text = wx.StaticText(panel, -1, "Hello World!")
        m_text.SetFont(wx.Font(14, wx.SWISS, wx.NORMAL, wx.BOLD))
        m_text.SetSize(m_text.GetBestSize())
        box.Add(m_text, 0, wx.ALL, 10)

        m_close = wx.Button(panel, wx.ID_CLOSE, "Close")
        box.Add(m_close, 0, wx.ALL, 10)

        panel.SetSizer(box)
        panel.Layout()
```
