# requests 获取网页(1)

获取url对应的网页HTML

```python
# -*- coding: UTF-8 -*-
import requests

def get_html(url):
    # TODO(You): 请在此实现代码
    return result

if __name__ == '__main__':
    url = "http://www.baidu.com"
    html = get_html(url)
    print(html)
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import requests


def get_html(url):
    response = requests.get(url=url)
    return response.text


def test():
    url = "http://www.baidu.com"
    html = get_html(url)
    print(html)

if __name__ == '__main__':
    test()
```

## 答案

```python
def get_html(url):
    response = requests.get(url=url)
    result = response.text
    return result
```

## 选项

### A

```python
def get_html(url):
    response = requests.get(url)
    result = response.text
    return result
```

### B

```python
def get_html(url):
    result = requests.get(url=url)
    return result
```

### C

```python
def get_html(url):
    response = requests.get(url=url)
    result = response.html
    return result
```
