# 正则表达式实战(2)

查找字符串里含有的全部 IPV4 和 IPV6 地址

```python
# -*- coding: UTF-8 -*-
import re

def find_all_ipv4(text):
    result = []
    ipv4 = r"((\b25[0-5]|\b2[0-4][0-9]|\b[01]?[0-9][0-9]?)(\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3})"

    # TODO(You)：请在此匹配ipv4

    for m in ret:
        result.append({'type': 'ipv4', 'value': m[0]})
    return result

def find_all_ipv6(text):
    result = []
    
    ipv6 = r"(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))"

    # TODO(You): 请在此匹配ipv6

    for m in ret:
        result.append({'type': 'ipv6', 'value': m[0]})
    return result

def find_all_ip(text):
    result = find_all_ipv4(text) + find_all_ipv6(text)
    return result

if __name__ == '__main__':
    input = 'IP地址有IPV4，例如：192.168.100.2，也有IPV6，例如：fe80:0000:0000:0000:0204:61ff:fe9d:f156，以及：fe80:0000:0000:0000:0204:61ff:fe9d:f156，还有 192.168.100.50'
    results = find_all_ip(input)
    for item in results:
        print('type: {}, value: {}'.format(item['type'], item['value']))
```

请选出下列能**正确**实现ipv4和ipv6正则匹配的选项。

## template

```python
import re


def find_all_ip(text):
    result = []

    ipv4 = r"((\b25[0-5]|\b2[0-4][0-9]|\b[01]?[0-9][0-9]?)(\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3})"
    ret = re.findall(ipv4, text)
    for m in ret:
        result.append({'type': 'ipv4', 'value': m[0]})

    ipv6 = r"(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))"
    ret = re.finditer(ipv6, text)
    for m in ret:
        result.append({'type': 'ipv6', 'value': m[0]})

    return result

if __name__ == '__main__':
    input = 'IP地址有IPV4，例如：192.168.100.2，也有IPV6，例如：fe80:0000:0000:0000:0204:61ff:fe9d:f156，以及：fe80:0000:0000:0000:0204:61ff:fe9d:f156，还有 192.168.100.50'
    results = find_all_ip(input)
    for item in results:
        print('type: {}, value: {}'.format(item['type'], item['value']))
```

## 答案

```python
def find_all_ipv4(text):
    ...
    ret = re.findall(ipv4, text)
    ...

def find_all_ipv6(text):
    ...
    ret = re.finditer(ipv6, text)
    ...
```

## 选项

### A

```python
def find_all_ipv4(text):
    ...
    ret = re.findall(text, ipv4)
    ...

def find_all_ipv6(text):
    ...
    ret = re.finditer(text, ipv6)
    ...
```

### B

```python
def find_all_ipv4(text):
    ...
    ret = text.findall(ipv4)
    ...

def find_all_ipv6(text):
    ...
    ret = text.finditer(ipv6)
    ...
```

### C

```python
def find_all_ipv4(text):
    ...
    ret = re.search(ipv4, text)
    ...

def find_all_ipv6(text):
    ...
    ret = re.search(ipv6, text)
    ...
```
