# Python 文件夹拷贝

实现文件夹拷贝，要求如下：

1. 使用 shutil 拷贝 "copy.py" 文件到 "/tmp/copy.py"
2. 拷贝 "copy.py" 文件到 "/tmp/copy2.py", 保留元数据
3. 递归拷贝目录 "./" 到 "/tmp/file_test/"，如果已存在就覆盖

```python
# -*- coding: UTF-8 -*-
import shutil

def test():
    # TODO(You): 请在此实现代码

if __name__ == '__main__':
    test()
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import shutil


def test():
    # 拷贝文件
    shutil.copy("copy.py", "/tmp/copy.py")

    # 拷贝文件，保持元数据
    shutil.copy2("copy.py", "/tmp/copy2.py")

    # 递归拷贝目录
    shutil.copytree("./", "/tmp/file_test/", dirs_exist_ok=True)

if __name__ == '__main__':
    test()
```

## 答案

```python
# 拷贝文件
shutil.copy(
    "copy.py", 
    "/tmp/copy.py"
)

# 拷贝文件，保持元数据
shutil.copy2(
    "copy.py", 
    "/tmp/copy2.py"
)

# 递归拷贝目录
shutil.copytree(
    "./", 
    "/tmp/file_test/", 
    dirs_exist_ok=True
)
```

## 选项

### A

```python
# 拷贝文件
shutil.copy(
    "/tmp/copy.py",
    "copy.py"
)

# 拷贝文件，保持元数据
shutil.copy2(
    "/tmp/copy2.py",
    "copy.py"
)

# 递归拷贝目录
shutil.copytree(
    "/tmp/file_test/", 
    "./", 
    dirs_exist_ok=True
)
```

### B

```python
shutil.copy(
    "copy.py", 
    "/tmp/copy.py"
)

# 拷贝文件，保持元数据
shutil.copy(
    "copy.py", 
    "/tmp/copy2.py"
)

# 递归拷贝目录
shutil.copytree(
    "./", 
    "/tmp/file_test/", 
    dirs_exist_ok=True
)
```

### C

```python
shutil.copy(
    "copy.py", 
    "/tmp/copy.py"
)

# 拷贝文件，保持元数据
shutil.copy2(
    "copy.py", 
    "/tmp/copy2.py"
)

# 递归拷贝目录
shutil.copytree(
    "./", 
    "/tmp/file_test/"
)
```
