# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python 时间加法
# 描述：从2008年1月开始到本月，遍历每一个月份的1号，并打印信息


from datetime import date, timedelta
import calendar


def next_month(d):
    return d+timedelta(calendar.monthrange(d.year, d.month)[1])


def for_each_month(start, finish, action):
    while start < finish:
        action(start)
        start = next_month(start)


def test():
    for_each_month(
        date(2008, 1, 1),
        date.today(),
        lambda d: print(d)
    )


if __name__ == '__main__':
    test()
