# Python 抽象类创建

使用 abc 库，创建抽象 BasePoint 类，创建 Point 子类，实现 dot 抽象方法，计算内积

```python
# -*- coding: UTF-8 -*-
import abc

# TODO(You): 请实现抽象类 BasePoint

class Point(BasePoint):
    def __init__(self, x, y, z) -> None:
        super().__init__(x, y, z)

    def dot(self, right):
        return self.x*right.x+self.y*right.y+self.z*right.z

if __name__ == '__main__':
    p1 = Point(0, 1, 2)
    p2 = Point(2, 4, 6)
    assert p1.dot(p2) == 16
    p1 = BasePoint(0, 1, 2)
    p2 = BasePoint(2, 4, 6)
    assert p1.dot(p2) is None
```

以下对 BasePoint 抽象类实现 **正确** 的代码是？

## template

```python
import abc

class BasePoint:
    def __init__(self, x, y, z) -> None:
        self.x = x
        self.y = y
        self.z = z

    @abc.abstractmethod
    def dot(self, right):
        pass


class Point(BasePoint):
    def __init__(self, x, y, z) -> None:
        super().__init__(x, y, z)

    def dot(self, right):
        return self.x*right.x+self.y*right.y+self.z*right.z


if __name__ == '__main__':
    p1 = Point(0, 1, 2)
    p2 = Point(2, 4, 6)
    assert p1.dot(p2) == 16
    p1 = BasePoint(0, 1, 2)
    p2 = BasePoint(2, 4, 6)
    assert p1.dot(p2) is None
```

## 答案

```python
class BasePoint:
    def __init__(self, x, y, z) -> None:
        self.x = x
        self.y = y
        self.z = z

    @abc.abstractmethod
    def dot(self, right):
        pass
```

## 选项

### A

```python
class BasePoint:
    def __init__(self, x, y, z) -> None:
        self.x = x
        self.y = y
        self.z = z

    @abstractmethod
    def dot(self, right):
        pass
```

### B

```python
class BasePoint:
    def __init__(self, x, y, z) -> None:
        self.x = x
        self.y = y
        self.z = z

    def dot(self, right):
        pass
```

### C

```python
class BasePoint:
    def __init__(self, x, y, z) -> None:
        self.x = x
        self.y = y
        self.z = z

    @abc.abstractmethod
    def dot(self, right):
```
