# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python 类的基本使用(1)
# 描述：编写一个kv容器类，支持 set/get/exist/keys/count 接口

class KeyValueSet:
    def __init__(self) -> None:
        self.dict = {}

    def set(self, key, value):
        self.dict[key] = value

    def get(self, key):
        return self.dict.get(key)

    def exist(self, key):
        return self.dict.get(key) is not None

    def keys(self):
        return self.dict.keys()


class GuessSentenceGame:
    def __init__(self):
        self.kv = KeyValueSet()
        self.score = 0

    def setup(self, sentences):
        for sentence in sentences:
            self.append(sentence)

    def append(self, sentence):
        cut_pos = sentence.find(' ')
        first_word, rest = sentence[0:cut_pos], sentence[cut_pos+1:].strip()
        self.kv.set(first_word, rest)

    def run(self):
        self.score = 0
        for first_word in self.kv.keys():
            ret = input("猜一猜下半句是什么？ {} -> :".format(first_word))
            value = self.kv.get(first_word)
            if ret == value:
                print('你太厉害了，这都能猜得到！+10分！')
                self.score += 10
            else:
                self.score -= 2
                print('哈哈，肯定猜不到得啦：{}->{}，扣除2分！'.format(first_word, value))
        print('游戏结束，你本次游戏得分：', self.score)


if __name__ == '__main__':

    sentences = [
        "hello world",
        'monkey king',
        'tomorrow is another day',
        "good bye!"
    ]

    game = GuessSentenceGame()
    game.setup(sentences)
    game.run()
