# Python 计时器

便利的 Python 计时器，统计从 0 遍历到 100000 消耗的时间，精确到毫秒

```python
# -*- coding: UTF-8 -*-
from datetime import datetime
from time import time, mktime

class TimeSpan:
    def __init__(self) -> None:
        self.start = round(time() * 1000)

    def elapse_mill_secs(self):
        # TODO(You): 请在此计算从开始到现在的耗时，精确到毫秒

    def elapse_secs(self):
        return (self.elapse_mill_secs())/1000

if __name__ == '__main__':
    s = TimeSpan()

    for i in range(0, 100000):
        pass
    print('耗时： {} 毫秒'.format(s.elapse_mill_secs()))
    print('耗时： {} 秒'.format(s.elapse_secs()))
```

以下实现，**错误** 的是？。

## template

```python
import time

class TimeSpan:
    def __init__(self) -> None:
        self.start = round(time.time() * 1000)

    def elapse_mill_secs(self):
        end = round(time.time() * 1000)
        return end-self.start

    def elapse_secs(self):
        end = round(time.time() * 1000)
        return (end-self.start)/1000


if __name__ == '__main__':
    s = TimeSpan()

    for i in range(0, 100000):
        pass
    print('耗时： {} 毫秒'.format(s.elapse_mill_secs()))
    print('耗时： {} 秒'.format(s.elapse_secs()))
```

## 答案

```python
def elapse_mill_secs(self):
    end = round(time(datetime.now())*1000)
    return end-self.start
```

## 选项

### A

```python
def elapse_mill_secs(self):
    end = round(time() * 1000)
    return end-self.start
```

### B

```python
def elapse_mill_secs(self):
    end = round(mktime(datetime.now().timetuple())*1000)
    return end-self.start
```

### C

```python
def elapse_mill_secs(self):
    end = round(datetime.now().timestamp() * 1000)
    return end-self.start
```
