# Python 类多态

Student 和 Teacher 类都继承 People 类。Student 和 Teacher 类可以动态改变 People 类的 infos 方法，添加子类新增信息。程序入口可以对它们统一处理，打印他们的基本信息

```python
# -*- coding: UTF-8 -*-
class People:
    def __init__(self, role, name, age):
        self.name = name
        self.age = age
        self.role = role

    def infos(self):
        return [
            f"name:{self.name}",
            f"age:{self.age}",
            f"role:{self.role}"
        ]

class Student(People):
    def __init__(self, no, name, age):
        super().__init__("student", name, age)
        self.no = no

    def infos(self):
        # TODO(You): 请在此实现学生类 infos 方法


class Teacher(People):
    def __init__(self, access_key, name, age):
        super().__init__("teacher", name, age)
        self.access_key = access_key

    def infos(self):
        # TODO(You): 请在此实现教师类 infos 方法


if __name__ == '__main__':
    peoples = [
        Teacher("ajladfjkadf", "Linus", 0)
    ]

    for i in range(0, 3):
        s = Student(i, f'somebody_{i}', 20+i)
        peoples.append(s)

    for p in peoples:
        print()
        for info in p.infos():
            print(info)
```

以下对 Student 和 Teacher 的 `infos` 方法实现正确的是？ 

## template

```python
class People:
    def __init__(self, role, name, age):
        self.name = name
        self.age = age
        self.role = role

    def infos(self):
        return [
            f"name:{self.name}",
            f"age:{self.age}",
            f"role:{self.role}"
        ]


class Student(People):
    def __init__(self, no, name, age):
        super().__init__("student", name, age)
        self.no = no

    def infos(self):
        info_list = super().infos()
        info_list.append(f'no:{self.no}')
        return info_list


class Teacher(People):
    def __init__(self, access_key, name, age):
        super().__init__("teacher", name, age)
        self.access_key = access_key

    def infos(self):
        info_list = super().infos()
        info_list.append(f'access_key:{self.access_key}')
        return info_list

if __name__ == '__main__':
    peoples = [
        Teacher("ajladfjkadf", "Linus", 0)
    ]

    for i in range(0, 3):
        s = Student(i, f'somebody_{i}', 20+i)
        peoples.append(s)
    for p in peoples:
        print()
        for info in p.infos():
            print(info)
```

## 答案

```python
class Student(People):
    ...
    def infos(self):
        info_list = super().infos()
        info_list.append(f'no:{self.no}')
        return info_list

class Teacher(People):
    ...
    def infos(self):
        info_list = super().infos()
        info_list.append(f'access_key:{self.access_key}')
        return info_list
```

## 选项

### A

```python
class Student(People):
    ...
    def infos(self):
        info_list = super.infos()
        info_list.append(f'no:{self.no}')
        return info_list

class Teacher(People):
    ...
    def infos(self):
        info_list = super.infos()
        info_list.append(f'access_key:{self.access_key}')
        return info_list
```

### B

```python
class Student(People):
    ...
    def infos(self):
        info_list = self.infos()
        info_list.append(f'no:{self.no}')
        return info_list

class Teacher(People):
    ...
    def infos(self):
        info_list = self.infos()
        info_list.append(f'access_key:{self.access_key}')
        return info_list
```

### C

```python
class Student(People):
    ...
    def infos(self):
        return [f'no:{self.no}']

class Teacher(People):
    ...
    def infos(self):
        return [f'access_key:{self.access_key}']
```
