# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：编程语言发明家
# 描述：使用 Python 函数处理编程语言发明家的信息

def parse_name(name):
    index = name.find('(')
    name_cn, name_en = name[0:index], name[index:]
    name_en = name_en[1:len(name_en)-1]
    return name_cn, name_en


def parse_parts(creator):
    index = creator.find(',')
    name, achievement = creator[0:index], creator[index+1:]
    return name.strip(), achievement.strip()


def parse_profile(creator):
    name, achievement = parse_parts(creator)
    name_cn, name_en = parse_name(name)
    return {
        'name_cn': name_cn,
        'name_en': name_en,
        'achievement': achievement
    }


def parse_creators(creators):
    profiles = []
    for creator in creators:
        profile = parse_profile(creator)
        profiles.append(profile)
    return profiles


if __name__ == '__main__':
    creators = [
        "约翰·巴科斯(JohnWarnerBackus), 创建了Fortran语言",
        "阿兰·库珀(Alan Cooper), 开发了Visual Basic语言",
        "艾兹格·迪杰斯特拉(Edsger Wybe Dijkstra), 提出了程序设计的框架结构",
        "詹姆斯·高斯林(James Gosling), 开发了Java语言",
        "安德斯·海尔斯伯格(Anders Hejlsberg), 开发了Turbo Pascal、Delphi、C#以及TypeScript",
        "葛丽丝·霍普(Grace Murray Hopper), 开发了Flow-Matic，该语言对COBOL造成了影响",
        "肯尼斯·艾佛森(Kenneth E. Iverson), 开发了APL，并与Roger Hui合作开发了J",
        "威廉·纳尔逊·乔伊(William Nelson Joy), 发明了vi，BSD Unix的前期作者，以及SunOS的发起人，该操作系统后来改名为Solaris",
        "艾伦·凯(Alan Curtis Kay), 开创了面向对象编程语言，以及Smalltalk的发起人",
        "罗布·派克(Brian Kernighan), 与丹尼斯·里奇合著第一本C程式设计语言的书籍，同时也是AWK与AMPL程式设计语言的共同作者",
        "约翰·麦卡锡(John McCarthy), 发明了LISP，在1956年的达特矛斯会议上提出了“人工智能”这个概念，被称为“人工智能之父",
        "约翰·冯·诺伊曼(John von Neumann), 操作系统概念的发起者",
        "丹尼斯·里奇(Dennis MacAlistair Ritchie), 发明了C语言，1978年与布莱恩·科尔尼干（Brian W. Kernighan）一起出版了名著《C程序设计语言（The C Programming Language）》",
        "比雅尼·斯特劳斯特鲁普(Bjarne Stroustrup), 他以创造C++编程语言而闻名，被称为“C++之父”",
        "肯·汤普逊(Kenneth Lane Thompson), 与丹尼斯·里奇同为1983年图灵奖得主。他与丹尼斯·里奇设计了B语言、C语言，创建了Unix和Plan 9操作系统，编程语言Go的共同作者。发展正规表示法，写作了早期的电脑文字编辑器QED与ed，定义UTF-8编码，以及发展电脑象棋",
        "尼克劳斯·维尔特(Niklaus Emil Wirth), 发明了Pascal与Modula",
        "拉里·沃尔(Larry Wall), 创造了Perl与Perl6",
        "吉多·范罗苏姆(Guido van Rossum), 创造了 Python"
    ]

    profiles = parse_creators(creators)
    print(profiles)
