# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：函数式编程
# 描述：高阶函数, 两个数组分别全排列后再配对，
# 例如:
# * [1,2]的全排列是[[1,2],[2,1]]
# * [3,4]的全排列是[[3,4],[4,3]]
# 配对后是：
# * [([1, 2], [3, 4]), ([2, 1], [4, 3])]

a = [1, 2, 3]
b = [3, 4, 5]


def permutation(s, nums, p, q):
    if p == q:
        s.append(list(nums))
    else:
        for i in range(p, q):
            nums[i], nums[p] = nums[p], nums[i]
            permutation(s, nums, p+1, q)
            nums[i], nums[p] = nums[p], nums[i]


if __name__ == '__main__':
    all_a = []
    permutation(all_a, a, 0, len(a))

    all_b = []
    permutation(all_b, b, 0, len(b))

    z = list(zip(all_a, all_b))
    print(z)
