# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python Matplot 风格绘制
# 描述：风格绘制 cos(x)-sin(x)+2cos(x/2)-2sin(x/2) + ... + ncos(x/n)-nsin(x/n)

import numpy as np
import matplotlib.pyplot as plt

from random import randint


color_table = [
    {"name": "Air Force blue", "value": "#5d8aa8", "lightness": "51.2"},
    {"name": "Alice blue", "value": "#f0f8ff", "lightness": "97.1"},
    {"name": "Alizarin crimson", "value": "#e32636", "lightness": "52"},
    {"name": "Almond", "value": "#efdecd", "lightness": "87.1"},
    {"name": "Amaranth", "value": "#e52b50", "lightness": "53.3"},
    {"name": "Amber", "value": "#ffbf00", "lightness": "50"},
    {"name": "American rose", "value": "#ff033e", "lightness": "50.6"},
    {"name": "Amethyst", "value": "#9966cc", "lightness": "60"},
    {"name": "Android Green", "value": "#a4c639", "lightness": "50"},
    {"name": "Anti-flash white", "value": "#f2f3f4", "lightness": "95.3"},
]


def random_hex_colors():
    index = randint(0, len(color_table))
    return color_table[index]['value']


def sum(m, n, s):
    if n < 1:
        plt.show()
        return
    X = np.linspace(-s*np.pi, s*np.pi, m, endpoint=True)
    C, S = np.cos(X), np.sin(X)
    for i in range(1, n+1):
        Cn, Sn = i*np.cos(X/i), i*np.sin(X/i)
        C += Cn
        S += Sn

    return X, C+S


if __name__ == '__main__':
    X, Y = sum(256, 10, 10)
    plt.plot(X, Y, 'y', linewidth=1.0, linestyle="--",
             label="y1", color=random_hex_colors())

    X, Y = sum(256, 20, 10)
    plt.plot(X, Y, 'y', linewidth=2.0, linestyle="-.",
             label="y2", color=random_hex_colors())

    X, Y = sum(256, 5, 10)
    plt.plot(X, Y, 'y', linewidth=2.0, linestyle="-",
             label="y2", color=random_hex_colors())

    X, Y = sum(256, 15, 10)
    plt.plot(X, Y, 'y', linewidth=2.0, linestyle=":",
             label="y2", color=random_hex_colors())

    plt.show()
