# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python 绘制爱心
# 描述：使用参数曲线绘制10个爱心

import numpy as np
import matplotlib.pyplot as plt


def love_s(i, a, b, c):
    s = np.array(np.sqrt(a-np.power((abs(i)-b), c)))
    return s


def love_t(i, a, b, c):
    t = -a*np.sqrt(b-c*abs(i))
    return t


if __name__ == '__main__':
    i = np.linspace(-2, 2, 100)
    x = love_s(i, 1, 1, 2)
    y = love_t(i, 2, 1, 0.5)

    plt.plot(i, x, '--')
    plt.plot(i, y, '--')
    plt.show()
