# Python 类创建

创建点对象，有多种方式创建一个类的实例，我们称一个点的x、y、z都一样的点为对角点。

```python
# -*- coding: UTF-8 -*-
class Point:
    # TODO(You): 添加代码支持类的创建

if __name__ == '__main__':
    points = []

    # TODO(You): 批量创建1000个对角点，第i个点的坐标是 (i,i,i)

    for point in points:
        print(point)
```

以下对上述代码补全，不正确的是？

## template

```python
class Point:
    def __init__(self, x, y, z):
        self.x = x
        self.y = y
        self.z = z

if __name__ == '__main__':
    points = []
    for i in range(1000):
        points.append(Point(i,i,i))

    for point in points:
        print(point)
```

## 答案

```python
class Point:
    def __init__(self, x, y, z):
        self.x = x
        self.y = y
        self.z = z

if __name__ == '__main__':
    points = []
    for i in range(1000):
        points.append(new Point(i,i,i))
```

## 选项

### A

```python
class Point:
    def __init__(self, x, y, z):
        self.x = x
        self.y = y
        self.z = z

if __name__ == '__main__':
    points = []
    for i in range(1000):
        points.append(Point(i,i,i))
```

### B

```python
# 通过 @classmethod 装饰器，增加一个类级别的创建方法，批量创建
class Point:
    def __init__(self, x, y, z):
        self.x = x
        self.y = y
        self.z = z

    @classmethod
    def create_diag_points(cls, count):
        # 在@classmethod修饰的方法中，其中 cls 表示 Point
        points = []
        for i in range(count):
            points.append(cls(i,i,i))
        return points

if __name__ == '__main__':
    points = Point.create_diag_points(1000)
```

### C

```python
# 添加类静态方法，批量创建对角点
class Point:
    def __init__(self, x, y, z):
        self.x = x
        self.y = y
        self.z = z

    @staticmethod
    def create_diag_points(count):
        points = []
        for i in range(count):
            points.append(Point(i,i,i))
        return points

if __name__ == '__main__':
    points = Point.create_diag_points(1000)
```
