# Python 异常处理

'a.json'文件不存在，下面代码会有异常，请编写异常控制代码，控制异常的最小范围，出现异常正常打印日志和堆栈

```python
# -*- coding: UTF-8 -*-
import json
import traceback
import logging
logger = logging.getLogger(__name__)

def load_json(file):
    with open(file, 'r') as f:
        return json.loads(f.read())

def test():
    # TODO(You): 
    ret = load_json('a.json')
    
if __name__ == '__main__':
    test()
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import json
import traceback
import logging
logger = logging.getLogger(__name__)


def load_json(file):
    with open(file, 'r') as f:
        return json.loads(f.read())


def test():
    try:
        ret = load_json('a.json')
        return {'err': 'success', 'result': ret}
    except Exception as e:
        logger.error(f"load json exception:{str(e)}")
        logger.error(traceback.format_exc())
        return {'err': 'exception'}

if __name__ == '__main__':
    test()
```

## 答案

```python
try:
    ret = load_json('a.json')
    return {'err': 'success', 'result': ret}
except Exception as e:
    logger.error(f"load json exception:{str(e)}")
    logger.error(traceback.format_exc())
    return {'err': 'exception'}
```

## 选项

### A

```python
try:
    ret = load_json('a.json')
    return {'err': 'success', 'result': ret}
except Exception(e):
    logger.error(f"load json exception:{str(e)}")
    logger.error(traceback.format_exc())
    return {'err': 'exception'}
```

### B

```python
try:
    ret = load_json('a.json')
    return {'err': 'success', 'result': ret}
except e:
    logger.error(f"load json exception:{str(e)}")
    logger.error(e.format_exc())
    return {'err': 'exception'}
```

### C

```python
try:
    ret = load_json('a.json')
    return {'err': 'success', 'result': ret}
except Exception as e:
    logger.error(f"load json exception:{str(e)}")
    logger.error(e.format_exc())
    return {'err': 'exception'}
```
