# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python 操作系统信息
# 描述：提示用户输入查看信息选项，输出对应操作系统信息，使用配置驱动的程序模式

import os


def select(config):
    print(config['options_tip'])
    options = config['options']

    selects = []
    for key in options:
        desc = options[key]["desc"]
        selects.append(key)
        print(f"* {key}: {desc}")
    print()

    input_tip = config['input_tip']
    select_tip = '/'.join(selects)
    tip = f'{input_tip}[{select_tip}, 按q退出]：'

    while True:
        key = input(tip)
        if key == 'q':
            break

        option = options.get(key)
        if option:
            desc = option['desc']
            print(f"@{desc}:")
            option['action']()
        else:
            print("[错误] 不支持的选项")


if __name__ == '__main__':

    def dump(tip, value):
        print(tip+':')
        print(value)
        print()

    def dump_basic_info():
        dump('os.name', os.name)

    def dump_path_info():
        dump('os.getcwd()', os.getcwd())
        dump('os.get_exec_path()', os.get_exec_path())

    def dump_env_info():
        dump('os.environ', os.environ)

    select({
        'options_tip': '通过 platform 可以查询一些有意思的信息',
        'input_tip': '请输入你感兴趣的信息',
        'options': {
            'b': {
                "desc": "b is basic, 系统基本信息",
                "action": dump_basic_info
            },
            'p': {
                "desc": "p is path, 路径信息",
                "action": dump_path_info
            },
            'e': {
                "desc": "e is env, 环境信息",
                "action": dump_env_info
            }
        },
    })
