# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python 函数调用
# 描述：使用函数设计一组 “容器API”：init/set/get/exist

# def init():
#     return {}


# def set(dict, key, value):
#     dict[key] = value


# def get(dict, key):
#     return dict.get(key)


# def exist(dict, key):
#     return dict.get(key) is not None

# def init():
#     return [], []

# def set(dict, key, value):
#     keys, values = dict
#     if not key in keys:
#         keys.append(key)
#         values.append(value)

# def get(dict, key):
#     keys, values = dict
#     if not key in keys:
#         return None
#     else:
#         return values[keys.index(key)]

# def exist(dict, key):
#     keys, values = dict
#     return key in keys

# def init():
#     return []


# def set(dict, key, value):
#     if not key in dict or dict.index(key) % 2 != 0:
#         dict.append(key)
#         dict.append(value)


# def get(dict, key):
#     if key in dict:
#         pos = dict.index(key)
#         if pos % 2 == 0:
#             return dict[pos+1]
#     return None


# def exist(dict, key):
#     return key in dict and dict.index(key) % 2 == 0

def init():
    return {"pre": None, "key": None, "value": None, "next": None}


def set(dict, key, value):
    node = dict
    while node is not None:
        if node['key'] == key:
            return
        last = node
        node = node['next']

    last['next'] = {"pre": last, "key": key, "value": value, "next": None}


def get(dict, key):
    node = dict
    while node is not None:
        if node['key'] == key:
            return node['value']
        node = node['next']


def exist(dict, key):
    node = dict
    while node is not None:
        if node['key'] == key:
            return True
        node = node['next']

    return False


if __name__ == '__main__':
    dict = init()
    for i in range(10):
        key = "key_{}".format(i)
        value = i
        set(dict, key, value)

    test_key = "key_4"
    if exist(dict, test_key):
        test_value = get(dict, test_key)
        print("key is: {}, value is: {}".format(test_key, test_value))
