# 使用相对路径导入包

良好的包/模块组织在程序开发中有重要的作用。随着项目代码的逐渐增加，一开始的单文件程序会逐渐膨胀，所幸 Python 提供当包模式可以良好应对通常的代码分层组织。

但是，当目录层次增加后，在下层目录里的代码引用其他目录的模块时，总是要输入全部路径有时并不方便，此时可以考虑使用 Python 的包相对路径来导入模块。

假设如下的`Python字符串`描述的包目录结构：

```python
relative_packages = '''
package/
    __init__.py
    subpackage1/
        __init__.py
        moduleX.py
        moduleY.py
    subpackage2/
        __init__.py
        moduleZ.py
    moduleA.py
'''
```

假设：

* `package/subpackage1/moduleY.py` 里定义了函数 `spam`
* `package/subpackage2/moduleZ.py` 里定义了函数 `eggs`
* `package/moduleA.py` 里定义了函数 `foo`

以下选项都是在文件`package/subpackage1/moduleX.py`里导入模块的代码，请问<span style="color:red">错误</span>的选项是哪个？你知道为什么吗？

## template

```python
if __name__ == '__main__':
    print(
        '''
Absolute imports may use either the import <> or from <> import <> syntax, but relative imports may only use the second form; the reason for this is that:
```import XXX.YYY.ZZZ```
should expose `XXX.YYY.ZZZ` as a usable expression, but .moduleY is not a valid expression.
    '''
    )
```

## 答案

```python
import ..subpackage2.moduleZ
```

## 选项

### A

```python
from .moduleY import spam
```

### B

```python
from .moduleY import spam as ham
```

### C

```python
from . import moduleY
```

### D

```python
from ..subpackage1 import moduleY
```

### E

```python
from ..subpackage2.moduleZ import eggs
```

### F

```python
from ..moduleA import foo
```
