# Python 安装交互式查询程序

Python 历史上有几个重要的版本节点：

* January 1994，Python1.0 发布
* 2000年10月16日，Python2.0 发布
* 2010年7月3日，Python2.7 发布，这是Python2.x的最后一个版本，Python2.x 和 Python3.x不兼容
* 2008年12月3日，Python3.0 发布，Python3引入多个和Python2.x不兼容的特性，Python 从2.x到3.x的迁移经历了比较长的时间，编程语言版本不兼容有时候会是个致命错误（例如Perl6），好在Python挺过来了。
* 2021年10月5号，Python3.10 发布，这是目前到2021年为止最新的版本
* 而最新的开发中版本是 Python3.11

不同平台对Python环境的默认支持是不同的：

* Windows 平台没有默认安装 Python
* Linux/Mac 平台大部分默认安装了 Python2.7

一般建议安装Python3.x 版本进行学习或开发。下面的`Python字典`给出了不同平台的安装信息：

```python
install = {
    "Windows": "请下载 Windows 安装包安装：https://www.python.org/downloads/windows/",
    "CentOS": "使用yum包管理器，执行命令：yum install -y python3",
    "Ubuntu": "使用apt-get包管理器，执行命令：apt-get install -y python3",
    "MacOS": "安装brew包管理器，然后执行命令： brew install python3",
}
```

基于这个信息，我们可以编写一个交互式Python程序，**要求支持用户操作**：

* 反复输入平台快捷键字符查询不同平台应该如何快速安装 Python3.x 版本
* 按`q`退出查询

```python
if __name__ == '__main__':
    install = {
        "Windows": "请下载 Windows 安装包安装：https://www.python.org/downloads/windows/",
        "CentOS": "使用yum包管理器，执行命令：yum install -y python3",
        "Ubuntu": "使用apt-get包管理器，执行命令：apt-get install -y python3",
        "MacOS": "安装brew包管理器，然后执行命令： brew install python3",
    }

    shortcut_keys = {}
    for platform in install:
        key = platform[0].lower()
        shortcut_keys[key] = platform
    
    # TODO(You): 请在此添加Python3.x安装文档交互式查询代码
```

以下是交互式执行的操作样例:

```bash
请选择安装平台[w/c/u/m, 按q退出]：w
Windows: 请下载 Windows 安装包安装：https://www.python.org/downloads/windows/
请选择安装平台[w/c/u/m, 按q退出]：c
CentOS: 使用yum包管理器，执行命令：yum install -y python3
请选择安装平台[w/c/u/m, 按q退出]：u
Ubuntu: 使用apt-get包管理器，执行命令：apt-get install -y python3
请选择安装平台[w/c/u/m, 按q退出]：m
MacOS: 安装brew包管理器，然后执行命令： brew install python3
请选择安装平台[w/c/u/m, 按q退出]：q
```

以下选项中对`Python3.x安装文档交互式查询代码`的实现<span style="color:red">错误</span>的是？

## template

```python
if __name__ == '__main__':
    install = {
        "Windows": "请下载 Windows 安装包安装：https://www.python.org/downloads/windows/",
        "CentOS": "使用yum包管理器，执行命令：yum install -y python3",
        "Ubuntu": "使用apt-get包管理器，执行命令：apt-get install -y python3",
        "MacOS": "安装brew包管理器，然后执行命令： brew install python3",
    }

    shortcut_keys = {}
    for platform in install:
        key = platform[0].lower()
        shortcut_keys[key] = platform

    while True:
        ret = input("请选择安装平台[w/c/u/m, 按q退出]：")
        platform = shortcut_keys.get(ret)

        if ret == 'q':
            break

        if platform is None:
            print("不支持的平台")
            continue

        doc = install.get(platform)
        print(f"{platform}: {doc}")
```

## 答案

```python
while True:
    ret = input("请选择安装平台[w/c/u/m, 按q退出]：")
    platform = shortcut_keys.get(ret)

    if ret == 'q':
        break
    
    if platform is None:
        print("不支持的平台")
        break
    
    doc = install.get(platform)
    print(f"{platform}: {doc}")
```

## 选项

### guard 模式

```python
while True:
    ret = input("请选择安装平台[w/c/u/m, 按q退出]：")
    if ret == 'q':
        break
    platform = shortcut_keys.get(ret)
    if platform is None:
        print("不支持的平台")
    else:
        doc = install.get(platform)
        print(f"{platform}: {doc}")
```

### if-else模式

```python
while True:
    ret = input("请选择安装平台[w/c/u/m, 按q退出]：")
    if ret != 'q':
        platform = shortcut_keys.get(ret)
        if platform is not None:
            doc = install.get(platform)
            print(f"{platform}: {doc}")
        else:
            print("不支持的平台")
    else:
        break
```

### 优先正文逻辑

```python
while True:
    ret = input("请选择安装平台[w/c/u/m, 按q退出]：")
    platform = shortcut_keys.get(ret)

    if ret == 'q':
        break
    
    if platform is None:
        print("不支持的平台")
        continue
    
    doc = install.get(platform)
    print(f"{platform}: {doc}")
```
