# Python PyQt 进度条(1)

使用 QThread 发送信号，接收信号一方打印并结束程序。程序的打印结果如下：

accept info from signal: Hello PyQT world:0.0!
accept info from signal: Hello PyQT world:0.2!
accept info from signal: Hello PyQT world:0.4!
accept info from signal: Hello PyQT world:0.6!
accept info from signal: Hello PyQT world:0.8!

使用 QThread 和 pyqtSignal 完成该功能：

```python
# -*- coding: UTF-8 -*-
class QProgressThread(QThread):
    _signal = pyqtSignal(ProgressInfo)

    def __init__(self, runner):
        super(QProgressThread, self).__init__()
        self.runner = runner

    def run(self):
        # TODO(You): 请在此实现运行代码

    def connect(self, on_signal):
        # TODO(You): 请在此实现绑定信号事件代码

    def __del__(self):
        self.wait()


if __name__ == "__main__":
    app = QApplication(sys.argv)

    def on_run(emit_progress):
        for i in range(0, 5):
            msg = f"Hello PyQT world:{i/5}!"
            emit_progress(i, msg)

    p = QProgressThread(on_run)

    def on_signal(info):
        print("accept info from signal:", info.msg)
        QApplication.quit()
    p.connect(on_signal)

    p.start()
    sys.exit(app.exec_())
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
class QProgressThread(QThread):
    _signal = pyqtSignal(ProgressInfo)

    def __init__(self, runner):
        super(QProgressThread, self).__init__()
        self.runner = runner

    def run(self):
        def emit_progress(progress, msg):
            info = ProgressInfo(progress, msg)
            self._signal.emit(info)
        self.runner(emit_progress)

    def connect(self, on_signal):
        self._signal.connect(on_signal)

    def __del__(self):
        self.wait()


if __name__ == "__main__":
    app = QApplication(sys.argv)

    def on_run(emit_progress):
        for i in range(0, 5):
            msg = f"Hello PyQT world:{i/5}!"
            emit_progress(i, msg)

    p = QProgressThread(on_run)

    def on_signal(info):
        print("accept info from signal:", info.msg)
        QApplication.quit()
    p.connect(on_signal)

    p.start()
    sys.exit(app.exec_())
```

## 答案

```python
class QProgressThread(QThread):
    _signal = pyqtSignal(ProgressInfo)
    ...
    def run(self):
        def emit_progress(progress, msg):
            info = ProgressInfo(progress, msg)
            self._signal.emit(info)
        self.runner(emit_progress)

    def connect(self, on_signal):
        self._signal.connect(on_signal)
```

## 选项

### A

```python
class QProgressThread(QThread):
    _signal = pyqtSignal(ProgressInfo)
    ...
    def run(self):
        def emit_progress(progress, msg):
            info = ProgressInfo(progress, msg)
            self._signal.emit(info)

        self.runner(emit_progress)

    def connect(self, on_signal):
        self._signal.Bind(on_signal)
```

### B

```python
class QProgressThread(QThread):
    _signal = pyqtSignal(ProgressInfo)
    ...
    def run(self):
        self._signal.emit(self.runner)

    def connect(self, on_signal):
        self._signal.connect(on_signal)
```

### C

```python
class QProgressThread(QThread):
    _signal = pyqtSignal(ProgressInfo)
    ...
    def run(self):
        progress, msg = self.runner()
        info = ProgressInfo(progress, msg)
        self._signal.emit(info)

    def connect(self, on_signal):
        self._signal.connect(on_signal)
```
