# lxml解析网页

使用xpath获取所有的文本

```python
# -*- coding: UTF-8 -*-
from lxml import etree

def fetch_text(html):
    # TODO(You): 请在此实现代码
    return result

if __name__ == '__main__':
    html = '''
        <html>
            <head>
                <title>这是一个简单的测试页面</title>
            </head>
            <body>
                <p>body 元素的内容会显示在浏览器中。</p>
                <p>title 元素的内容会显示在浏览器的标题栏中。</p>
            </body>
        </html>
        '''
    imgs = fetch_text(html)
    print(imgs)
```

请选出下列能**正确**实现这一功能的选项。

## template

```python

from lxml import etree


def fetch_text(html):
    html = etree.HTML(html)
    result = html.xpath("//text()")
    return result


def test():
    html = '''
        <html>
            <head>
                <title>这是一个简单的测试页面</title>
            </head>
            <body>
                <p>body 元素的内容会显示在浏览器中。</p>
                <p>title 元素的内容会显示在浏览器的标题栏中。</p>
            </body>
        </html>
        '''
    imgs = fetch_text(html)
    print(imgs)

if __name__ == '__main__':
    test()
```

## 答案

```python
def fetch_text(html):
    html = etree.HTML(html)
    result = html.xpath("//text()")
    return result
```

## 选项

### A

```python
def fetch_text(html):
    html = etree.HTML(html)
    result = html.xpath("/text()")
    return result
```

### B

```python
def fetch_text(html):
    html = etree.HTML(html)
    result = html.xpath(".//text")
    return result
```

### C

```python
def fetch_text(html):
    html = etree.HTML(html)
    result = html.xpath("/text()")
    return result
```
