# urllib post请求

urllib post请求

```python
# -*- coding: UTF-8 -*-
import urllib.request
import urllib.parse

def get_response(url, data):
    # TODO(You):  请在此编写代码
    return result

if __name__ == '__main__':
    data = {
        "key1": "value1",
        "key2": "value2"
    }
    url = "http://httpbin.org/post"
    html = get_response(url, data)
    print(html)
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import urllib.request
import urllib.parse


def get_response(url, data):
    data = bytes(urllib.parse.urlencode(data), encoding='utf8')
    response = urllib.request.urlopen(url, data=data)
    buff = response.read()
    result = buff.decode("utf8")
    return result

if __name__ == '__main__':
    data = {
        "key1": "value1",
        "key2": "value2"
    }
    url = "http://httpbin.org/post"
    html = get_response(url, data)
    print(html)
```

## 答案

```python
def get_response(url, data):
    data = bytes(urllib.parse.urlencode(data), encoding='utf8')
    response = urllib.request.urlopen(
        url, data=data
    )
    buff = response.read()
    result = buff.decode("utf8")
    return result
```

## 选项

### A

```python
def get_response(url, data):
    data = bytes(urllib.parse.urlencode(data, encoding='utf8'))
    response = urllib.request.urlopen(
        url, data=data
    )
    buff = response.read()
    result = buff.decode("utf8")
    return result
```

### B

```python
def get_response(url, data):
    data = bytes(urllib.parse.urlencode(data), encoding='utf8')
    response = urllib.request.urlopen(
        url, data
    )
    buff = response.read()
    result = buff.decode("utf8")
    return result
```

### C

```python
def get_response(url, data):
    data = urllib.parse.urlencode(data, encoding='utf8')
    response = urllib.request.urlopen(
        url, data=data
    )
    buff = response.read()
    result = buff.decode("utf8")
    return result
```
