# Python MySQL Connection

封装一个 MySQL 连接类，继承自 MySQLConnector，请先完成【Python MySQL Connector】

```python
# -*- coding: UTF-8 -*-
import logging
from error_code import ErrorCode
from mysql.connector import Error
from mysql_connector import MySQLConnector
logger = logging.Logger(__name__)
mysql_connection_pool = None

class MySQLConnection(MySQLConnector):
    def __init__(self, host, port, user, password, database) -> None:
        super().__init__(host, port, user, password, database)

    def execute(self, sql, args):
        # TODO(You): 请在此实现代码

if __name__ == '__main__':
    kv = MySQLConnection(
        "127.0.0.1", 3306,
        "root", "WNpx8c\zr!fF",
        "test"
    )

    ret = kv.open()
    assert ret['err'] == ErrorCode.SUCCESS

    ret = kv.execute("select * from test")
    assert ret['err'] == ErrorCode.SUCCESS
    ret = kv.close()
    assert ret['err'] == ErrorCode.SUCCESS
```

请选出下列能**正确**实现 execute 方法的选项。

## template

```python
import logging
from error_code import ErrorCode
from mysql.connector import Error
from mysql_connector import MySQLConnector
logger = logging.Logger(__name__)
mysql_connection_pool = None


class MySQLConnection(MySQLConnector):
    def __init__(self, host, port, user, password, database) -> None:
        super().__init__(host, port, user, password, database)

    def execute(self, sql, args):
        cursor = self.conn.cursor()
        try:
            cursor.execute(sql, args)
            results = cursor.fetchall() or []
            self.conn.commit()
            return {'err': ErrorCode.SUCCESS, 'results': list(map(lambda t: t[0], results))}
        except Error as e:
            self.conn.rollback()
            logger.error('execute mysql query exception:', str(e))
            return {'err': ErrorCode.DB_QUERY_EXCEPT}
        finally:
            cursor.close()


if __name__ == '__main__':
    kv = MySQLConnection(
        "127.0.0.1", 3306,
        "root", "WNpx8c\zr!fF",
        "test"
    )

    ret = kv.open()
    assert ret['err'] == ErrorCode.SUCCESS

    ret = kv.execute("select * from test")
    assert ret['err'] == ErrorCode.SUCCESS
    ret = kv.close()
    assert ret['err'] == ErrorCode.SUCCESS
```

## 答案

```python
class MySQLConnection(MySQLConnector):
    ...
    def execute(self, sql, args):
        cursor = self.conn.cursor()
        try:
            cursor.execute(sql, args)
            results = cursor.fetchall() or []
            self.conn.commit()
            return {
                'err': ErrorCode.SUCCESS, 
                'results': list(map(lambda t: t[0], results))
            }
        except Error as e:
            self.conn.rollback()
            logger.error('execute mysql query exception:', str(e))
            return {'err': ErrorCode.DB_QUERY_EXCEPT}
        finally:
            cursor.close()
```

## 选项

### A

```python
class MySQLConnection(MySQLConnector):
    ...
    def execute(self, sql, args):
        cursor = self.conn.cursor()
        try:
            cursor.execute(sql, args)
            results = cursor.fetchall()
            self.conn.commit()
            return {
                'err': ErrorCode.SUCCESS, 
                'results': list(map(lambda t: t[0], results))
            }
        except Error as e:
            self.conn.rollback()
            logger.error('execute mysql query exception:', str(e))
            return {'err': ErrorCode.DB_QUERY_EXCEPT}
        finally:
            cursor.close()
```

### B

```python
class MySQLConnection(MySQLConnector):
    ...
    def execute(self, sql, args):
        cursor = self.conn.cursor()
        cursor.execute(sql, args)
        results = cursor.fetchall() or []
        self.conn.commit()
        return {
            'err': ErrorCode.SUCCESS, 
            'results': list(map(lambda t: t[0], results))
        }
```

### C

```python
class MySQLConnection(MySQLConnector):
    ...
    def execute(self, sql, args):
        cursor = self.conn.cursor()
        try:
            cursor.execute(sql, args)
            results = cursor.fetchall() or []
            return {
                'err': ErrorCode.SUCCESS, 
                'results': list(map(lambda t: t[0], results))
            }
        except Error as e:
            logger.error('execute mysql query exception:', str(e))
            return {'err': ErrorCode.DB_QUERY_EXCEPT}
```
