# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python 操作系统信息
# 描述：提示用户输入选项，输出对应选项类型的平台信息

import platform


def select(config, action):
    print(config['options_tip'])

    selects = []
    for key in config['options']:
        option = config['options'][key]
        selects.append(key)
        print(f"* {key}: {option}")

    tip = f"{config['input_tip']}[{'/'.join(selects)}, 按q退出]："
    while True:
        key = input(tip)
        if key == 'q':
            break
        else:
            action(key)
            print()


def test():
    def action(key):
        if key == 'p':
            print(platform.architecture())
            print(platform.platform())
            print(platform.processor())
            print(platform.machine())
        elif key == 'py':
            print(platform.python_build())
            print(platform.python_implementation())
            print(platform.python_compiler())
            print(platform.python_version())

    select({
        'options_tip': '通过 platform 可以查询一些有意思的信息',
        'input_tip': '请输入你感兴趣的信息',
        'options': {
            'p': "p is platform, 平台信息",
            'py': "py is python, Python 信息",
        },
    }, action)


if __name__ == '__main__':
    test()
