# Python 类的基本使用(3)

基于第1题，还可以通过类的组合，使用组合而非继承实现类的扩展，支持类似 `redis` 的 `hset`/`hget`/`hkeys` 扩展接口

相比于本节第2题，下面代码使用组合的方式复合`KeyValueSet`的功能，从而实现`HashKeyValueSet`。

```python
from key_value_set import KeyValueSet

class HashKeyValueSet:
    def __init__(self, kvset) -> None:
        super().__init__()
        self.kvset = kvset

    def hset(self, hash_key, key, value):
        # TODO(You): 请在此添加代码

    def hget(self, hash_key, key):
        hash_set = self.kvset.get(hash_key)
        if hash_set is None:
            return None
        else:
            return hash_set.get(key)

    def hkeys(self, hash_key):
        hash_set = self.kvset.get(hash_key)
        if hash_set is None:
            return []
        else:
            return hash_set.keys()
```

类`HashKeyValueSet`的用例如下：

```python
def test():
    hashset = HashKeyValueSet(KeyValueSet())

    hashset.hset('puzzle', 'hello', 'world!')
    hashset.hset('puzzle', 'monkey', 'king!')
    hashset.hset('puzzle', 'tomorrow', 'is another day')
    hashset.hset('puzzle', 'good', 'bye!')

    keys = hashset.hkeys('puzzle')
    for key in keys:
        ret = input("猜一猜下半句是什么？ {} -> :".format(key))
        value = hashset.hget('puzzle', key)
        if ret == value:
            print('你太厉害了，这都能猜得到！')
        else:
            print('哈哈，肯定猜不到得啦：{}->{}'.format(key, value))

if __name__ == '__main__':
    test()
```

请选出下面对两种`TODO`的实现代码中，<span style="color:red">错误</span> 的选项。

## template

```python
from key_value_set import KeyValueSet


class HashKeyValueSet:
    def __init__(self, kvset) -> None:
        super().__init__()
        self.kvset = kvset

    def hset(self, hash_key, key, value):
        self.kvset.set(hash_key, {key: value})

    def hget(self, hash_key, key):
        hash_set = self.kvset.get(hash_key)
        if hash_set is None:
            return None
        else:
            return hash_set.get(key)

    def hkeys(self, hash_key):
        hash_set = self.kvset.get(hash_key)
        if hash_set is None:
            return []
        else:
            return hash_set.keys()

def test():
    hashset = HashKeyValueSet(KeyValueSet())

    hashset.hset('puzzle', 'hello', 'world!')
    hashset.hset('puzzle', 'monkey', 'king!')
    hashset.hset('puzzle', 'tomorrow', 'is another day')
    hashset.hset('puzzle', 'good', 'bye!')

    keys = hashset.hkeys('puzzle')
    for key in keys:
        ret = input("猜一猜下半句是什么？ {} -> :".format(key))
        value = hashset.hget('puzzle', key)
        if ret == value:
            print('你太厉害了，这都能猜得到！')
        else:
            print('哈哈，肯定猜不到得啦：{}->{}'.format(key, value))


if __name__ == '__main__':
    test()
```

## 答案

```python
self.set(hash_key, {key: value})
```

## 选项

### A

```python
self.kvset.set(hash_key, {key: value})
```

### B

```python
hash_set = self.kvset.get(hash_key)
if hash_set is None:
    hash_set = {key: value}
else:
    hash_set[key] = value
self.kvset.set(hash_key, hash_set)
```

### C

```python
hash_set = self.kvset.get(hash_key)
if hash_set is None:
    hash_set = {}
    hash_set[key] = value
    self.kvset.set(hash_key, hash_set)
else:
    hash_set[key] = value
    self.kvset.set(hash_key, hash_set)
```
