# 看不见的开始和结束

![](https://userblink.csdnimg.cn/20211123/huanhuilong/pic/6f53d912e1d2671fa0b6c9ef4eaa9d30-2.jpg?x-oss-process=image/interlace,1/format,jpg/resize,w_375)

作用域是编程语言里的一个重要的概念，特别是块作用域，编程语言一般会使用明确的符号标记一个作用域的开始和结束。

例如 C、C++、Java、C#、Rust、Go、JavaScript 等常见语言都是用`"{"`和`"}"`来标记一个块作用域的开始和结束：

```c
// 这是一个C语言程序
if(i<10){
    if(i<5){
        print("win more!");
    }else{
        print("win");
    }
}else{
    print("loose");
}
```

```rust
// 这是一个 Rust 语言程序
if i<10 {
    if i<5 {
        println!("win more!");
    }else{
        println!("win");
    }
}else{
    println!("loose");
}
```


而 Python 程序则是用缩进来表示块作用域的开始和结束：

```python
# 这是一个 Python 程序
if i<10:
    if i<5:
        print("win more!")
    else:
        print("win")
else:
    print("loose")
```

Python 对缩进有严格的要求，同一个源文件里，缩进必须保持一致，例如都是2个空格或者4个空格。Python 这么做的理由是使用缩进更简洁，同时不用考虑`"{"`要放在哪一行，而且是用缩进足够Python解释器正确解析。但是使用缩进如果没有编辑器自动检测和格式化也会带来一些不必要的麻烦。

请选出下面的 Python 代码中，<span style="color:red">缩进错误</span> 的选项。

## template

```python
# 全局代码
for i in range(0, 10):
    print('global code: {}'.format(i))
    if i == 5:
        print('global code: *')


# 函数
def test():
    for i in range(0, 10):
        print('function code: {}'.format(i))
        if i == 5:
            print('function code: *')


# 类
class Test():
    def __init__(self) -> None:
        pass

    def test(self):
        for i in range(0, 10):
            print('member function code: {}'.format(i))
            if i == 5:
                print('member function code: *')


if __name__ == '__main__':
    i = 0
    c = 5
    max = 10
    while i < max:
        d = max-i-i

      if abs(d) < 3:
        print(i, max-i)
      else:
        pass

        i += 1
```


## 答案

```python
if __name__ == '__main__':
    i = 0
    c = 5
    max = 10
    while i < max:
        d = max-i-i

      if abs(d) < 3:
        print(i, max-i)
      else:
        pass

        i += 1
```

## 选项

### A

```python
for i in range(0, 10):
    print('global code: {}'.format(i))
    if i == 5:
        print('global code: *')
```

### B

```python
def test():
    for i in range(0, 10):
        print('function code: {}'.format(i))
        if i == 5:
            print('function code: *')
```

### C

```python
class Test():
    def __init__(self):
        pass

    def test(self):
        for i in range(0, 10):
            print('member function code: {}'.format(i))
            if i == 5:
                print('member function code: *')
```
