# Python PyQt 进度条(2)

![](https://gitcode.net/csdn/skill_tree_python/-/raw/master/data/2.python%E4%B8%AD%E9%98%B6/4.%E6%A1%8C%E9%9D%A2%E5%BA%94%E7%94%A8%E5%BC%80%E5%8F%91/2.PyQT/q_progress_bar.png)

请先完成上一题。封装一个能显示进度条的 PyQT GUI 对话框, 对话框功能如下：

1. 点击按钮“看资料+做题，就有技能树进度” 进度条开始步进
2. 每次步进，进度条往前走1步，标题显示“Python技能树->PyQT:{i}/5”
3. 一共5步，运行过程中按钮不能点击，运行结束可以重新点击

```python
# -*- coding: UTF-8 -*-
import sys
import time
import math
from PyQt5.QtWidgets import QApplication, QWidget
from PyQt5.QtWidgets import QPushButton, QProgressBar
from PyQt5.QtWidgets import QVBoxLayout, QMessageBox
from q_progress_thread import QProgressThread

class QRunnerProgressBar(QWidget):
    def __init__(self, count, tip, runner):
        super(QRunnerProgressBar, self).__init__()
        self.setWindowTitle('QRunnerProgressBar')

        self.vbox = QVBoxLayout()

        self.btn = QPushButton(tip)
        self.btn.clicked.connect(self.on_btn_click)
        self.vbox.addWidget(self.btn)

        self.pbar = QProgressBar(self)
        self.pbar.setValue(0)
        self.vbox.addWidget(self.pbar)

        self.setLayout(self.vbox)
        self.resize(300, 100)
        self.show()

        self.count = count
        self.runner = runner

    def on_btn_click(self):
        # 复用上一题的 QProgressThread
        self.thread = QProgressThread(self.runner)
        self.thread.connect(self.on_progress)
        self.thread.start()
        self.btn.setEnabled(False)

    def on_progress(self, info):
        percent_value = int(math.floor(info.progress*100/self.count))
        self.pbar.setValue(int(percent_value))
        self.setWindowTitle(info.msg)
        if self.pbar.value() == self.count:
            self.pbar.setValue(0)
            self.btn.setEnabled(True)

    def closeEvent(self, event):
        self.thread = None


if __name__ == "__main__":
    app = QApplication(sys.argv)

    def on_run(emit_progress):
        for i in range(0, 5):
            time.sleep(1)
            emit_progress(i+1, f'Python技能树->PyQT:{i+1}/5')

    p = QRunnerProgressBar(
        count=5,
        tip='看资料+做题，就有技能树进度',
        runner=on_run
    )
    sys.exit(app.exec_())
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import sys
import time
import math
from PyQt5.QtWidgets import QApplication, QWidget
from PyQt5.QtWidgets import QPushButton, QProgressBar
from PyQt5.QtWidgets import QVBoxLayout, QMessageBox
from q_progress_thread import QProgressThread

class QRunnerProgressBar(QWidget):
    def __init__(self, count, tip, runner):
        super(QRunnerProgressBar, self).__init__()
        self.setWindowTitle('QRunnerProgressBar')

        self.vbox = QVBoxLayout()

        self.btn = QPushButton(tip)
        self.btn.clicked.connect(self.on_btn_click)
        self.vbox.addWidget(self.btn)

        self.pbar = QProgressBar(self)
        self.pbar.setValue(0)
        self.vbox.addWidget(self.pbar)

        self.setLayout(self.vbox)
        self.resize(300, 100)
        self.show()

        self.count = count
        self.runner = runner

    def on_btn_click(self):
        self.thread = QProgressThread(self.runner)
        self.thread.connect(self.on_progress)
        self.thread.start()
        self.btn.setEnabled(False)

    def on_progress(self, info):
        percent_value = int(math.floor(info.progress*100/self.count))
        self.pbar.setValue(int(percent_value))
        self.setWindowTitle(info.msg)
        if self.pbar.value() == 100:
            self.pbar.setValue(0)
            self.btn.setEnabled(True)
            self.setWindowTitle('QRunnerProgressBar')

    def closeEvent(self, event):
        self.thread = None


if __name__ == "__main__":
    app = QApplication(sys.argv)

    def on_run(emit_progress):
        for i in range(0, 5):
            time.sleep(1)
            emit_progress(i+1, f'Python技能树->PyQT:{i+1}/5')

    p = QRunnerProgressBar(
        count=5,
        tip='看资料+做题，就有技能树进度',
        runner=on_run
    )
    sys.exit(app.exec_())
```

## 答案

```python
class QRunnerProgressBar(QWidget):
    ...
    def on_btn_click(self):
        # 复用上一题的 QProgressThread
        self.thread = QProgressThread(self.runner)
        self.thread.connect(self.on_progress)
        self.thread.start()
        self.btn.setEnabled(False)

    def on_progress(self, info):
        percent_value = int(math.floor(info.progress*100/self.count))
        self.pbar.setValue(int(percent_value))
        self.setWindowTitle(info.msg)
        if self.pbar.value() == 100:
            self.pbar.setValue(0)
            self.btn.setEnabled(True)
            self.setWindowTitle('QRunnerProgressBar')
```

## 选项

### A

```python
class QRunnerProgressBar(QWidget):
    ...
    def on_btn_click(self):
        # 复用上一题的 QProgressThread
        self.thread = QProgressThread(self.runner)
        self.thread.connect(self.on_progress)
        self.thread.start()
        self.btn.setEnabled(False)

    def on_progress(self, info):
        percent_value = int(math.floor(info.progress*100/self.count))
        self.pbar.setValue(int(percent_value))
        self.setWindowTitle(info.msg)
```

### B

```python
class QRunnerProgressBar(QWidget):
    ...
    def on_btn_click(self):
        # 复用上一题的 QProgressThread
        self.thread = QProgressThread(self.runner)
        self.thread.connect(self.on_progress)
        self.thread.start()
        self.btn.setEnabled(False)

    def on_progress(self, info):
        percent_value = int(math.floor(info.progress*100/self.count))
        self.pbar.setValue(int(percent_value))
        self.setWindowTitle(info.msg)
        if self.pbar.value() == self.count:
            self.pbar.setValue(0)
            self.btn.setEnabled(True)
            self.setWindowTitle('QRunnerProgressBar')
```

### C

```python
class QRunnerProgressBar(QWidget):
    ...
    def on_btn_click(self):
        # 复用上一题的 QProgressThread
        self.thread = QProgressThread(self.runner)
        self.thread.connect(self.on_progress)
        self.thread.start()
        self.btn.setEnabled(False)

    def on_progress(self, info):
        self.pbar.setValue(info.progress)
        self.setWindowTitle(info.msg)
        if self.pbar.value() == 100:
            self.pbar.setValue(0)
            self.btn.setEnabled(True)
            self.setWindowTitle('QRunnerProgressBar')
```

### D

```python
class QRunnerProgressBar(QWidget):
    ...
    def on_btn_click(self):
        # 复用上一题的 QProgressThread
        self.thread = QProgressThread(self.runner)
        self.thread.connect(self.on_progress)
        self.thread.start()

    def on_progress(self, info):
        percent_value = int(math.floor(info.progress*100/self.count))
        self.pbar.setValue(int(percent_value))
        self.setWindowTitle(info.msg)
        if self.pbar.value() == 100:
            self.pbar.setValue(0)
            self.setWindowTitle('QRunnerProgressBar')
```
