# urlib 获取网页(1)

将 url 对应的网页下载到本地

```python
# -*- coding: UTF-8 -*-
import urllib.request

def get_html(url):
    # TODO(You): 请在此实现代码
    return html

if __name__ == '__main__':
    url = "http://www.baidu.com"
    html = get_html(url)
    print(html)
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import urllib.request

def get_html(url):
    response = urllib.request.urlopen(url)
    buff = response.read()
    html = buff.decode("utf8")
    return html

if __name__ == '__main__':
    url = "http://www.baidu.com"
    html = get_html(url)
    print(html)
```

## 答案

```python
def get_html(url):
    response = urllib.request.urlopen(url)
    buff = response.read()
    html = buff.decode("utf8")
    return html
```

## 选项

### A

```python
def get_html(url):
    response = urllib.request.urlopen(url)
    buff = response.read()
    html = buff.encode("utf8")
    return html
```

### B

```python
def get_html(url):
    response = urllib.request.urlopen(url)
    buff = response.readline()
    html = buff.decode("utf8")
    return html
```

### C

```python
def get_html(url):
    response = urllib.request(url)
    buff = response.read()
    html = buff.decode("utf8")
    return html
```

### D

```python
def get_html(url):
    response = urllib.request.urlopen(url)
    buff = response.read()
    html = buff.decode()
    return html
```
