# 使用函数组织代码

函数是代码复用的最简单形式。在第一章里我们已经多次不经介绍地使用了函数来组织代码。现在可以系统认识下函数的参数。

```python
# -*- coding: UTF-8 -*-
def dump(index, default=0, *args, **kw):
    print('打印函数参数')
    print('---')
    print('index:', index)
    print('default:', default)
    for i, arg in enumerate(args):
        print(f'arg[{i}]:', arg)
    for key,value in kw:
        print(f'keyword_argument {key}:{value}')
    print('')

if __name__=='__main__':
    dump(0)
    dump(0,2)
    dump(0,2,"Hello","World")
    dump(0,2,"Hello","World", install='Python', run='Python Program')
```

Python函数的参数十分灵活，例如上面的例子：

* `index`: 按顺序位置指定的参数
* `default=0`: 带有默认值的参数
* `*args`: 0个或多个可选的参数
* `**kw`: 0个或多个关键字参数

查看打印结果可以增加对此的理解，语句 `` 的输出是：

```bash
打印函数参数
---
index: 0
default: 2
arg[0]: Hello
arg[1]: World
keyword_argument install:Python
keyword_argument run:Python Program
```

Python 的函数可以调用别的函数，当调用的是自己本身时，就形成了递归调用。以下是一个待完成的递归调用程序，功能需求是：

* 循环打印"Hello,World!"的每个字符
* 循环5次。

```python
# -*- coding: UTF-8 -*-
def circulate_print(str, count=0):
    if count == 5:
        return
    for char in str:
        print(char)
    
    # TODO(You): 请在此完成函数递归调用

if __name__ == '__main__':
    str = "Hello,World!"
    circulate_print(str)
```

请在下面的选项中，选出<span style="color:red">错误</span> 的递归调用选项。

## 答案

```python
circulate_print(str, count)
```

## 选项

### A

```python
circulate_print(str, count+1)
```

### B

```python
count = count+1
circulate_print(str, count)
```

### C

```python
circulate_print(str, count=count+1)
```
