# Python 结构化模式匹配(1)

Python 3.10 引入了结构化模式匹配。请使用 Python 3.10+ 版本测试本代码。

## template

```python
import argparse

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('command', choices=['push', 'pull', 'commit'])
    args = parser.parse_args()

    match args.command:
        case 'push':
            print('pushing')
        case 'pull':
            print('pulling')
        case _:
            parser.error(f'{args.command!r} not yet implemented')
```

## 答案

```python
import argparse

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('command', choices=['push', 'pull', 'commit'])
    args = parser.parse_args()

    match args.command:
        case 'push':
            print('pushing')
        case 'pull':
            print('pulling')
        case _:
            parser.error(f'{args.command!r} not yet implemented')
```

## 选项

### A

```python
import argparse

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('command', choices=['push', 'pull', 'commit'])
    args = parser.parse_args()

    switch args.command:
        case 'push':
            print('pushing')
        case 'pull':
            print('pulling')
        case _:
            parser.error(f'{args.command!r} not yet implemented')
```

### B

```python
import argparse

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('command', choices=['push', 'pull', 'commit'])
    args = parser.parse_args()

    match args.command:
        case 'push':
            print('pushing')
        case 'pull':
            print('pulling')
        default:
            parser.error(f'{args.command!r} not yet implemented')
```

### C

```python
import argparse

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('command', choices=['push', 'pull', 'commit'])
    args = parser.parse_args()

    match args.command:
        if 'push':
            print('pushing')
        elif 'pull':
            print('pulling')
        else _:
            parser.error(f'{args.command!r} not yet implemented')
```
