# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python WxPython 例子
# 描述：创建窗口、菜单、显示文本，关闭

import wx


class BasicFrame(wx.Frame):
    def __init__(self, title, pos, size):
        wx.Frame.__init__(self, None, title=title,
                          pos=pos, size=size)
        self.init_close_event()
        self.init_menu_bar()
        self.init_status_bar()

    def init_close_event(self):
        self.Bind(wx.EVT_CLOSE, self.OnClose)

    def init_menu_bar(self):
        menuBar = wx.MenuBar()
        menu = wx.Menu()
        m_exit = menu.Append(
            wx.ID_EXIT,
            "E&xit\tAlt-X",
            "Close window and exit program."
        )
        self.Bind(wx.EVT_MENU, self.OnClose, m_exit)
        menuBar.Append(menu, "&File")
        self.SetMenuBar(menuBar)

    def init_status_bar(self):
        self.statusbar = self.CreateStatusBar()

    def OnClose(self, event):
        dlg = wx.MessageDialog(
            self,
            "Do you really want to close this application?",
            "Confirm Exit", wx.OK | wx.CANCEL | wx.ICON_QUESTION
        )
        result = dlg.ShowModal()
        dlg.Destroy()
        if result == wx.ID_OK:
            self.Destroy()


if __name__ == '__main__':
    app = wx.App(redirect=True)
    top = BasicFrame(
        title="Hello World",
        pos=(150, 150),
        size=(350, 200)
    )
    top.Show()
    app.MainLoop()
