# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python WxPython 例子
# 描述：创建窗口、菜单、显示文本，关闭

import wx
from create_window import BasicFrame


class PanelFrame(BasicFrame):
    def __init__(self, title, pos, size):
        super().__init__(title, pos, size)
        self.init_panel()

    def init_panel(self):
        panel = wx.Panel(self)
        box = wx.BoxSizer(wx.VERTICAL)

        m_text = wx.StaticText(panel, -1, "Hello World!")
        m_text.SetFont(wx.Font(14, wx.SWISS, wx.NORMAL, wx.BOLD))
        m_text.SetSize(m_text.GetBestSize())
        box.Add(m_text, 0, wx.ALL, 10)

        m_close = wx.Button(panel, wx.ID_CLOSE, "Close")
        m_close.Bind(wx.EVT_BUTTON, self.OnClose)
        box.Add(m_close, 0, wx.ALL, 10)

        panel.SetSizer(box)
        panel.Layout()


if __name__ == '__main__':
    app = wx.App(redirect=True)
    top = PanelFrame(
        title="Hello World",
        pos=(150, 150),
        size=(350, 200)
    )
    top.Show()
    app.MainLoop()
