import sys
from PyQt5.QtCore import QThread, pyqtSignal
from PyQt5.QtWidgets import QApplication


class ProgressInfo:
    def __init__(self, progress, msg):
        self.progress = progress
        self.msg = msg


class QProgressThread(QThread):
    _signal = pyqtSignal(ProgressInfo)

    def __init__(self, runner):
        super(QProgressThread, self).__init__()
        self.runner = runner

    def run(self):
        def emit_progress(progress, msg):
            info = ProgressInfo(progress, msg)
            self._signal.emit(info)
        self.runner(emit_progress)

    def connect(self, on_signal):
        self._signal.connect(on_signal)

    def __del__(self):
        self.wait()


if __name__ == "__main__":
    app = QApplication(sys.argv)

    def on_run(emit_progress):
        for i in range(0, 5):
            msg = f"Hello PyQT world:{i/5}!"
            emit_progress(i, msg)

    p = QProgressThread(on_run)

    def on_signal(info):
        print("accept info from signal:", info.msg)
        QApplication.quit()
    p.connect(on_signal)

    p.start()
    sys.exit(app.exec_())
