# 爬虫验证码识别

使用百度 paddle ocr 库可以识别验证码

1. 安装paddle：`pip install paddlepaddle==2.1.0`
2. 安装paddle ocr: `pip install paddleocr==2.0.6`
3. 编写代码

```python
# -*- coding: UTF-8 -*-
import re
from paddleocr import PaddleOCR

if __name__ == "__main__":
    ocr_client = PaddleOCR(
        use_angle_cls=True,
        lang="ch",
        use_space_char=True,
        use_zero_copy_run=True,
        use_mp=True,
        total_process_num=16,
        ir_optim=True,
        enable_mkldnn=True,
        rec_batch_num=1,
        max_batch_size=1
    )
    result = ocr_client.ocr('code.png', det=True, rec=True, cls=True)
    code_text = []
    for line in result:
        print(line)
        # TODO(You): 请正确提取文本
        text = ...
        code_text.append(text)
    print(code_text)
```

其中 line 的打印例子是：

```bash
[[[881.0, 77.0], [1128.0, 56.0], [1161.0, 439.0], [914.0, 460.0]], ('6', 0.97982866)]
```

以下正确提取`text`的是？

## 答案

```bash
text = line[1][0]
```

## 选项

### A

```bash
text = line[0][1]
```

### B

```bash
text = line[0][0]
```

### C

```bash
text = line[1][1]
```
