# selectolax示例

使用 selectolax 提取页面p标签的内容，代码如下：

```python
# -*- coding: UTF-8 -*-
from selectolax.parser import HTMLParser

def get_p(html):
    p_list = []
    for node in HTMLParser(html).css("p"):
        # TODO(You): 正确的提取代码
    return p_list

html = '''
    <html>
        <head>
            <title>这是一个简单的测试页面</title>
        </head>
        <body>
            <p class="item-0">body 元素的内容会显示在浏览器中。</p>
            <p class="item-1">title 元素的内容会显示在浏览器的标题栏中。</p>
        </body>
    </html>
    '''

print(get_p(html))

```

关于缺失代码部分，以下选项<span style="color:red">正确</span>的是：

## 答案

```python
p_list.append(node.text())
```

## 选项

### A

```python
p_list.append(node.text)
```

### B

```python
p_list.append(node)
```

### C

```python
p_list.append(node.get_text())
```
