# 爬取动态页面

现在想爬取一个url为下拉滚动的页面，下列选项可以爬取到下列页面内容的是：

## 答案

```python
# -*- coding: UTF-8 -*-
import time
from selenium import webdriver
from bs4 import BeautifulSoup

driver = webdriver.Chrome()
driver.get(url)
Thread.sleep(1000)

page_size = 10
for i in range(page_size):
    time.sleep(2)
    js = "var q=document.documentElement.scrollTop=10000"
    driver.execute_script(js)

page = BeautifulSoup(driver.page_source, 'lxml')
print(page.text)
```

## 选项

### A

```bash
以上均不正确
```

### B

```python
import requests

response = requests.get(url=url)
page = BeautifulSoup(response.text, 'lxml')
print(page.text)
```

### C

```python
import urllib.request

response = urllib.request.urlopen(url)
buff = response.read()
html = buff.decode("utf8")
page = BeautifulSoup(html, 'lxml')
print(page.text)
```
