# 错误码处理

编写一个错误码枚举，实现一个 "错误码转换成字符串" 的静态方法： internal_ret_2_http

```python
# -*- coding: UTF-8 -*-
from enum import Enum

class ErrorCode(Enum):
    SUCCESS = 0
    FAILED = 1
    NOT_FOUND = 2
    ALREADY_EXIST = 3
    INVALID_PARAMETERS = 4

    @staticmethod
    def internal_ret_2_http(ret):
        # TODO(You): 请在此实现代码

if __name__ == '__main__':
    ret = {'err': ErrorCode.NOT_FOUND}
    ErrorCode.internal_ret_2_http(ret)
    assert ret['err'] == 'not_found'
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
from enum import Enum

class ErrorCode(Enum):
    SUCCESS = 0
    FAILED = 1
    NOT_FOUND = 2
    ALREADY_EXIST = 3
    INVALID_PARAMETERS = 4

    @staticmethod
    def internal_ret_2_http(ret):
        ret['err'] = ret['err'].name.lower()

if __name__ == '__main__':
    ret = {'err': ErrorCode.NOT_FOUND}
    ErrorCode.internal_ret_2_http(ret)
    assert ret['err'] == 'not_found'
```

## 答案

```python
ret['err'] = ret['err'].name.lower()
```

## 选项

### A

```python
ret['err'] = ret['err'].name
```

### B

```python
ret['err'] = str(ret['err']).lower()
```

### C

```python
ret['err'] = str(ret['err'])
```
