# Python 常用标准库(1)

sys, os, math, time, date

请在使用的时候查文档，例如日期文档：https://docs.python.org/zh-cn/3/library/datetime.html#datetime.datetime

请选出以下所有的 assert **不全部为 True** 的选项

## template

```python
import sys
import os
import math
import time
from datetime import datetime
if __name__ == '__main__':
    assert type(sys.argv) == type([])
    assert os.path.exists(__file__) == True
    assert math.pow(2, 3) == 8
    assert type(time.time()) == float
    assert datetime.now().year >= 2021
```

## 答案

```python
assert type(sys.argv) == type([])
assert os.path.exists(__file__) == True
assert math.pow(2, 3) == 2+2+2+2
assert type(time.time()) == int
assert datetime.now().year >= 2121
```

## 选项

### A

```python
assert type(sys.argv) == type([])
assert os.path.exists(__file__) == True
assert math.pow(2, 3) == 2*2*2
assert type(time.time()) == float
assert datetime.now().year >= 2021
```

### B

```python
assert type(sys.argv) == type([])
assert os.path.exists(__file__) == True
assert math.pow(2, 3) == 8
assert type(time.time()) == type(2.3)
assert datetime.now().year >= 2021
```

### C

```python
assert type(sys.argv) == list
assert os.path.exists(__file__) == True
assert math.pow(2, 3) == 8
assert type(time.time()) == float
assert datetime.now().year >= 2021
```
