# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python 文件读写
# 描述：一种基于 sha256 的文件分片 hash 计算方式

import hashlib


def file_piece_sha256(in_file_path, piece_size):
    sha256 = hashlib.sha256()
    with open(in_file_path, "rb") as in_file:
        while True:
            piece = in_file.read(piece_size)
            if piece:
                sha256.update(piece.hex().encode('utf-8'))
            else:
                break
    return sha256.digest().hex()


if __name__ == '__main__':
    ret = file_piece_sha256('file_piece_sha256.py', 128)
    print("file hash is: ", ret)
