# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python 列表推导式(2)
# 描述：Python 独步天下的推导式表达式，使用列表推导式过滤不热的天气


if __name__ == '__main__':
    obj_list = [
        {"key": "day1", "value": "大雨哗啦啦啦啦下", 'tags': ["不热"]},
        {"key": "day2", "value": "很热很热，哥哥不在家，我一个人出去旅行", 'tags': ["热"]},
        {"key": "day3", "value": "阴天有时下肉丸", 'tags': ["不热"]}
    ]

    print('')
    print("# 过滤出不热的日子")
    non_hot_days = [d for d in obj_list if '不热' in d['tags']]
    for day in non_hot_days:
        print("* [{}]: {}".format(day['key'], day['value']))

    print('')
