# Python 列表推导式(2)

Python 独步天下的推导式表达式，使用列表推导式过滤不热的天气

```python
# -*- coding: UTF-8 -*-
if __name__ == '__main__':
    obj_list = [
        {"key": "day1", "value": "大雨哗啦啦啦啦下", 'tags': ["不热"]},
        {"key": "day2", "value": "很热很热，哥哥不在家，我一个人出去旅行", 'tags': ["热"]},
        {"key": "day3", "value": "阴天有时下肉丸", 'tags': ["不热"]}
    ]

    print('')
    print("# 过滤出不热的日子")
    
    # TODO(you): 请在此实现过滤代码

    for day in non_hot_days:
        print("* [{}]: {}".format(day['key'], day['value']))

    print('')
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
if __name__ == '__main__':
    obj_list = [
        {"key": "day1", "value": "大雨哗啦啦啦啦下", 'tags': ["不热"]},
        {"key": "day2", "value": "很热很热，哥哥不在家，我一个人出去旅行", 'tags': ["热"]},
        {"key": "day3", "value": "阴天有时下肉丸", 'tags': ["不热"]}
    ]

    print('')
    print("# 过滤出不热的日子")
    non_hot_days = [d for d in obj_list if '不热' in d['tags']]
    for day in non_hot_days:
        print("* [{}]: {}".format(day['key'], day['value']))

    print('')
```

## 答案

```python
non_hot_days = [d for d in obj_list if '不热' in d['tags']]
```

## 选项

### A

```python
non_hot_days = [d for d in obj_list if '热' in d['tags']]
```

### B

```python
non_hot_days = [d for d in obj_list: if '不热' in d['tags']]
```

### C

```python
non_hot_days = [for d in obj_list if '不热' in d['tags']]
```
