# Python 列表推导式(1)

Python 独步天下的推导式表达式，使用列表推导式过滤出偶数列表

```python
# -*- coding: UTF-8 -*-
if __name__ == '__main__':
    list = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    
    print('')
    print("# 使用列表推导式过滤出偶数")

    # TODO(you): 请在此实现过滤代码

    for n in even:
        print(n)

    print('')
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
if __name__ == '__main__':
    list = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    print('')
    print("# 使用列表推导式过滤出偶数")
    even = [n for n in list if n % 2 == 0]
    for n in even:
        print(n)

    print('')
```

## 答案

```python
even = [n for n in list if n % 2 == 0]
```

## 选项

### A

```python
even = [n for n in list: if n % 2 == 0]
```

### B

```python
even = [n for n in list if n % 2 != 0]
```

### C

```python
even = [for n in list if n % 2 == 0]
```
