# Python 字典推导式

Python 独步天下的推导式表达式，使用字典推导式过滤，打印非windows系统的 Python 安装介绍

```python
# -*- coding: UTF-8 -*-
if __name__ == '__main__':
    install = {
        "w": {
            "platform": "Window",
            "desc": "请下载 Windows 安装包安装：https://www.python.org/downloads/windows/"
        },
        "l": {
            "platform": "Linux",
            "desc": "请下载 Linux 的 Python 源码安装：https://www.python.org/downloads/source/",
        },
        "m": {
            "platform": "MacOS",
            "desc": "请下载 Mac 的安装包：https://www.python.org/downloads/macos/，或者使用 brew install python 安装",
        }
    }

    # TODO(you): 请在此实现 non_windows 赋值代码
    
    print("打算最近只用非Windows系统安装Python了:")
    print()
    for key in non_windows:
        target = non_windows[key]
        print("安装平台：{}".format(target['platform']))
        print("安装说明：{}".format(target['desc']))
        print()
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
if __name__ == '__main__':
    install = {
        "w": {
            "platform": "Window",
            "desc": "请下载 Windows 安装包安装：https://www.python.org/downloads/windows/"
        },
        "l": {
            "platform": "Linux",
            "desc": "请下载 Linux 的 Python 源码安装：https://www.python.org/downloads/source/",
        },
        "m": {
            "platform": "MacOS",
            "desc": "请下载 Mac 的安装包：https://www.python.org/downloads/macos/，或者使用 brew install python 安装",
        }
    }

    non_windows = {key: install[key] for key in install if key != 'w'}
    print("打算最近只用非Windows系统安装Python了:")
    print()
    for key in non_windows:
        target = non_windows[key]
        print("安装平台：{}".format(target['platform']))
        print("安装说明：{}".format(target['desc']))
        print()
```

## 答案

```python
non_windows = {key: install[key] for key in install if key != 'w'}
```

## 选项

### A

```python
non_windows = {key: install[key] for key in install: if key != 'w'}
```

### B

```python
non_windows = {install[key] for key in install if key != 'w'}
```

### C

```python
non_windows = {key:install[key] for key in install}
```
