# Python 内置类型

内置类的使用，列表元素去重+过滤小于3的元素

```python
# -*- coding: UTF-8 -*-
def remove_duplicates(items):
    # TODO(You): 实现去重

def filter_element(items, bound):
    # TODO(You): 实现过滤

if __name__ == '__main__':
    a = [1, 2, 3, 4, 4, 5, 5]
    print('输入: {}'.format(a))

    res = remove_duplicates(a)
    print('去重后的结果：{}'.format(res))

    bound = 3
    res = filter_element(a, bound)
    print('过滤小于{}的元素:{}'.format(bound, res))
```

请选出以下对`remove_duplicates`或`filter_element` **实现错误**的代码。

## template

```python

def remove_duplicates(items):
    res = list(set(items))
    return res

def filter_element(items, bound):
    res = []
    for item in items:
        if item >= bound:
            res.append(item)
    return res

if __name__ == '__main__':
    a = [1, 2, 3, 4, 4, 5, 5]
    print('输入: {}'.format(a))

    res = remove_duplicates(a)
    print('去重后的结果：{}'.format(res))

    bound = 3
    res = filter_element(a, bound)
    print('过滤小于{}的元素:{}'.format(bound, res))
```

## 答案

```python
def filter_element(items, bound):
    res = [item for item in items if item < bound]
    return res
```

## 选项

### A

```python
def remove_duplicates(items):
    res = list(set(items))
    return res
```

### B

```python
def remove_duplicates(items):
    res = []
    for item in items:
        if not item in res:
            res.append(item)
    return res
```

### C

```python
def filter_element(items, bound):
    res = []
    for item in items:
        if item >= bound:
            res.append(item)
    return res
```
