# Python 类的基本使用(1)

下面的类封装了一组 `set`/`get`/`keys` 接口

```python
# -*- coding: UTF-8 -*-
class KeyValueSet:
    def __init__(self) -> None:
        self.dict = {}

    def set(self, key, value):
        self.dict[key] = value

    def get(self, key):
        return self.dict.get(key)

    def keys(self):
        return self.dict.keys()
```

请你使用类 `KeyValueSet` 完成一个交互式命令行`你想我猜`游戏。支持：

* 装载N个句子对
* `你猜我想` 闯关，输出上半句，等待用户猜测下半句
* 如果猜中就累加10分，否则扣2分
* 全部结束输出用户本次得分

我们编写一个新的class，内部通过组合`KeyValueSet`来支持上述功能，程序框架如下：

```python
# -*- coding: UTF-8 -*-
class GuessSentenceGame:
    def __init__(self):
        self.kv = KeyValueSet()
        self.score = 0

    def setup(self, sentences):
        # TODO(You): 请在此编写装载逻辑
    
    def guess(self, first_word):
        # TODO(You): 请在此编写猜测结果，返回 err, value
    
    def run(self):
        self.score = 0
        for first_word in self.kv.keys():
            ret = input("猜一猜下半句是什么？ {} -> :".format(first_word))
            err, value = self.guess(first_word)
            if err==0:
                print('你太厉害了，这都能猜得到！+10分！')
                self.score += 10
            else:
                self.score -= 2
                print('哈哈，肯定猜不到得啦：{}->{}，扣除2分！'.format(first_word, value))
        print('游戏结束，你本次游戏得分：', self.score)

if __name__ == '__main__':

    sentences = [
        "hello world",
        'monkey king',
        'tomorrow is another day',
        "good bye"
    ]

    game = GuessSentenceGame()
    game.setup(sentences)
    game.run()
```

一个示例输出是：

```bash
猜一猜下半句是什么？ hello -> :world
你太厉害了，这都能猜得到！+10分！
猜一猜下半句是什么？ monkey -> :king
你太厉害了，这都能猜得到！+10分！
猜一猜下半句是什么？ tomorrow -> :is another day
你太厉害了，这都能猜得到！+10分！
猜一猜下半句是什么？ good -> :a
哈哈，肯定猜不到得啦：good->bye，扣除2分！
游戏结束，你本次游戏得分： 28
```

请选出下面的实现代码中，<span style="color:red">错误</span> 的选项。

## template

```python
class KeyValueSet:
    def __init__(self) -> None:
        self.dict = {}

    def set(self, key, value):
        self.dict[key] = value

    def get(self, key):
        return self.dict.get(key)

    def exist(self, key):
        return self.dict.get(key) is not None

    def keys(self):
        return self.dict.keys()


class GuessSentenceGame:
    def __init__(self):
        self.kv = KeyValueSet()
        self.score = 0

    def setup(self, sentences):
        for sentence in sentences:
            self.append(sentence)

    def append(self, sentence):
        cut_pos = sentence.find(' ')
        first_word, rest = sentence[0:cut_pos], sentence[cut_pos+1:].strip()
        self.kv.set(first_word, rest)

    def run(self):
        self.score = 0
        for first_word in self.kv.keys():
            ret = input("猜一猜下半句是什么？ {} -> :".format(first_word))
            value = self.kv.get(first_word)
            if ret == value:
                print('你太厉害了，这都能猜得到！+10分！')
                self.score += 10
            else:
                self.score -= 2
                print('哈哈，肯定猜不到得啦：{}->{}，扣除2分！'.format(first_word, value))
        print('游戏结束，你本次游戏得分：', self.score)


if __name__ == '__main__':

    sentences = [
        "hello world",
        'monkey king',
        'tomorrow is another day',
        "good bye!"
    ]

    game = GuessSentenceGame()
    game.setup(sentences)
    game.run()
```

## 答案

```python
class GuessSentenceGame:
    ...

    def setup(sentences):
        for sentence in sentences:
            cut_pos = sentence.find(' ')
            self.kv.set(sentence[0:cut_pos], sentence[cut_pos+1:].strip())
        
    def guess(first_word):
        self.kv.get(first_word)
        return 0, value if value else 1, None
```

## 选项

### A

```python
class GuessSentenceGame:
    ...

    def setup(self, sentences):
        for sentence in sentences:
            first_word, rest = self.parse_sentence(sentence)
            self.kv.set(first_word, rest)
    
    def parse_sentence(self, sentence):
        cut_pos = sentence.find(' ')
        return sentence[0:cut_pos], sentence[cut_pos+1:].strip()

    def guess(self, first_word):
        value = self.kv.get(first_word)
        return 0, value if value else 1, None
```

### B

```python
class GuessSentenceGame:
    ...

    def setup(self, sentences):
        for sentence in sentences:
            cut_pos = sentence.find(' ')
            first_word, rest = sentence[0:cut_pos], sentence[cut_pos+1:].strip()
            self.kv.set(first_word, rest)

    def guess(self, first_word):
        value = self.kv.get(first_word)
        err = 0 if value else 1
        return err, value
```

### C

```python
class GuessSentenceGame:
    ...

    def setup(self, sentences):
        for sentence in sentences:
            self.append(sentence)

    def append(self, sentence):
        cut_pos = sentence.find(' ')
        first_word, rest = sentence[0:cut_pos], sentence[cut_pos+1:].strip()
        self.kv.set(first_word, rest)
    
    def guess(self, first_word):
        ret = self.kv.get(first_word)
        if ret is None:
            return 1, None
        else:
            return 0, ret
```
