# Python Tkinter 开发应用基础

基本的控件组装，组装一个数字记录窗口，添加必要的事件绑定

```python
# -*- coding: UTF-8 -*-
from tkinter import Tk, Button, messagebox

class NumberRecorder:
    def __init__(self) -> None:
        self.numbers = []

    def render(self):
        self.main_window = Tk()
        show = Button(
            self.main_window,
            text=f"查看结果",
            command=self.on_show
        )
        show.pack()

        # TODO(You): 请在此组装1-9数字按钮

        self.main_window.mainloop()

    def on_show(self):
        messagebox.showinfo("输入数字", f"{','.join(self.numbers)}")

    def on_click(self, i):
        self.numbers.append(i)

if __name__ == '__main__':
    app = NumberRecorder()
    app.render()
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
from tkinter import Tk, Button, messagebox


class NumberRecorder:
    def __init__(self) -> None:
        self.numbers = []

    def render(self):
        self.main_window = Tk()
        show = Button(
            self.main_window,
            text=f"查看结果",
            command=self.on_show
        )
        show.pack()

        for i in range(0, 9):
            number = Button(
                self.main_window,
                text=f"{i}",
                command=lambda: self.on_click(i)
            )
            number.pack()

        self.main_window.mainloop()

    def on_show(self):
        messagebox.showinfo("输入数字", f"{','.join(self.numbers)}")

    def on_click(self, i):
        self.numbers.append(i)

if __name__ == '__main__':
    app = NumberRecorder()
    app.render()
```

## 答案

```python
for i in range(0, 9):
    number = Button(
        self.main_window,
        text=f"{i}",
        command=lambda: self.on_click(i)
    )
    number.pack()
```

## 选项

### A

```python
for i in range(0, 9):
    number = Button(
        self.main_window,
        text=f"{i}",
        command=lambda: self.on_click(i)
    )
```

### B

```python
for i in range(0, 9):
    number = Button(
        text=f"{i}",
        command=lambda: self.on_click(i)
    )
    number.pack()
```

### C

```python
for i in range(0, 9):
    number = Button(
        self.main_window,
        text=f"{i}",
    )
    number.pack()
```
