# 错误码处理

编写一个错误码枚举，支持转换成字符串格式方法： internal_ret_2_http

```python
# -*- coding: UTF-8 -*-
from enum import Enum

class ErrorCode(Enum):
    # TODO(You): 请在此定义错误码

    @staticmethod
    def internal_ret_2_http(ret):
        ret['err'] = ret['err'].name.lower()

if __name__ == '__main__':
    ret = {'err': ErrorCode.NOT_FOUND}
    ErrorCode.internal_ret_2_http(ret)
    assert ret['err'] == 'not_found'
```

以下对错误码定义 **正确** 的是？。

## template

```python
from enum import Enum


class ErrorCode(Enum):
    SUCCESS = 0
    FAILED = 1
    NOT_FOUND = 2
    ALREADY_EXIST = 3
    INVALID_PARAMETERS = 4

    @staticmethod
    def internal_ret_2_http(ret):
        ret['err'] = ret['err'].name.lower()

if __name__ == '__main__':
    ret = {'err': ErrorCode.NOT_FOUND}
    ErrorCode.internal_ret_2_http(ret)
    assert ret['err'] == 'not_found'
```

## 答案

```python
class ErrorCode(Enum):
    SUCCESS = 0
    FAILED = 1
    NOT_FOUND = 2
    ALREADY_EXIST = 3
    INVALID_PARAMETERS = 4
```

## 选项

### A

```python
class ErrorCode(Enum):
    SUCCESS: 0
    FAILED: 1
    NOT_FOUND: 2
    ALREADY_EXIST: 3
    INVALID_PARAMETERS: 4
```

### B

```python
class ErrorCode(Enum):
    SUCCESS
    FAILED
    NOT_FOUND
    ALREADY_EXIST
    INVALID_PARAMETERS
```

### C

```python
class ErrorCode(Enum):
    'SUCCESS' = 0
    'FAILED' = 1
    'NOT_FOUND' = 2
    'ALREADY_EXIST' = 3
    'INVALID_PARAMETERS' = 4
```
