# Python 文件统计

统计文件中行数，非空行数，以及空格间隔的token数

```python
# -*- coding: UTF-8 -*-
import json

def count_file(file):
    line_count = 0
    non_empty_line_count = 0
    token_count = 0

    with open(file, 'r') as f:
        while True:
            # 读取每行
            line = f.readline()
            if not line:
                break

            line_count += 1
            line_len = len(line)
            line_token_count = 0

            # TODO(You): 请在此实现统计单行token数

            token_count += line_token_count
            if line_token_count > 0:
                non_empty_line_count += 1

    return {
        'file': file,
        'line_count': line_count,
        'line_token_count': token_count,
        'non_empty_line_count': non_empty_line_count
    }

if __name__ == '__main__':
    ret = count_file('count_file.py')
    print('行数：', ret['line_count'])
    print('非空行：', ret['non_empty_line_count'])
    print('非空词数：', ret['line_token_count'])
    with open('/tmp/count.json', 'w') as f:
        f.write(json.dumps(ret, indent=2, ensure_ascii=False))
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
import json


def count_file(file):
    line_count = 0
    non_empty_line_count = 0
    token_count = 0

    with open(file, 'r') as f:
        while True:
            line = f.readline()
            if not line:
                break
            line_count += 1

            line_len = len(line)
            i = 0
            blank = True
            line_token_count = 0
            while i < line_len:
                char = line[i]
                if char in [' ', '\t', '\b']:
                    blank = True
                else:
                    if blank:
                        line_token_count += 1
                    blank = False
                i += 1

            token_count += line_token_count
            if line_token_count > 0:
                non_empty_line_count += 1

    return {
        'file': file,
        'line_count': line_count,
        'line_token_count': token_count,
        'non_empty_line_count': non_empty_line_count
    }


if __name__ == '__main__':
    ret = count_file('count_file.py')
    print('行数：', ret['line_count'])
    print('非空行：', ret['non_empty_line_count'])
    print('非空词数：', ret['line_token_count'])
    with open('/tmp/count.json', 'w') as f:
        f.write(json.dumps(ret, indent=2, ensure_ascii=False))
```

## 答案

```python
blank = False
for char in line:
    if char in [' ', '\t', '\b']:
        blank = True
    else:
        if blank:
            line_token_count += 1
        blank = False
```

## 选项

### A

```python
blank = True
i = 0
while i < line_len:
    char = line[i]
    if char in [' ', '\t', '\b']:
        blank = True
    else:
        if blank:
            line_token_count += 1
        blank = False
    i += 1
```

### B

```python
blank = True
i = 0
while i < line_len:
    char = line[i]
    if char in [' ', '\t', '\b', '\n']:
        if not blank:
            line_token_count += 1
        blank = True
    else:
        blank = False
    i += 1
```

### C

```python
blank = True
for char in line:
    if char in [' ', '\t', '\b', '\n']:
        if not blank:
            line_token_count += 1
        blank = True
    else:
        blank = False
```
